package in.clouthink.daas.bm.domain.rest;

import in.clouthink.daas.bm.core.MessageReceiver;
import in.clouthink.daas.bm.domain.request.BusinessMessageQueryParameter;
import org.springframework.data.domain.Page;

public interface BusinessMessageRestSupport {

	/**
	 * @param id
	 * @param receiver
	 * @return
	 */
	BusinessMessageDetail getBusinessMessageDetail(String id, MessageReceiver receiver);

	/**
	 * @param request
	 * @param receiver
	 * @return
	 */
	Page<BusinessMessageSummary> listBusinessMessagePage(BusinessMessageQueryParameter request,
														 MessageReceiver receiver);

	/**
	 * @param id
	 * @param receiver
	 */
	void readBusinessMessage(String id, MessageReceiver receiver);

	/**
	 * @param id
	 * @param receiver
	 */
	void processBusinessMessage(String id, MessageReceiver receiver);

	/**
	 * @param id
	 * @param receiver
	 */
	void deleteBusinessMessage(String id, MessageReceiver receiver);

}
