package in.clouthink.daas.bm.domain.rest;

import in.clouthink.daas.bm.core.BusinessMessageType;
import in.clouthink.daas.bm.domain.model.FailureMessage;
import org.springframework.beans.BeanUtils;

/**
 */
public class FailureMessageSummary {

	public static FailureMessageSummary from(FailureMessage from) {
		if (from == null) {
			return null;
		}
		FailureMessageSummary result = new FailureMessageSummary();
		convert(from, result);
		return result;
	}

	public static void convert(FailureMessage from, FailureMessageSummary result) {
		BeanUtils.copyProperties(from, result);
	}

	/**
	 * @return the uuid to identify the business message
	 */
	String id;

	/**
	 * @return the type to indicate which channel will be sent through
	 */
	BusinessMessageType type;

	/**
	 * @return the category of message ( for business )
	 */
	String category;

	/**
	 * @return the message title
	 */
	String title;

	/**
	 * @return the tar (in string expression) which will send to
	 */
	String target;

	/**
	 * @return how many times re-tried
	 */
	int retried;

	/**
	 * @return the latest error code
	 */
	String errorCode;

	/**
	 * @return the latest error message
	 */
	String errorMessage;

	/**
	 * @return the final status , succeed or not ( because some type of message can be re-send )
	 */
	boolean finalSucceed;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public BusinessMessageType getType() {
		return type;
	}

	public void setType(BusinessMessageType type) {
		this.type = type;
	}

	public String getCategory() {
		return category;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getTarget() {
		return target;
	}

	public void setTarget(String target) {
		this.target = target;
	}

	public int getRetried() {
		return retried;
	}

	public void setRetried(int retried) {
		this.retried = retried;
	}

	public String getErrorCode() {
		return errorCode;
	}

	public void setErrorCode(String errorCode) {
		this.errorCode = errorCode;
	}

	public String getErrorMessage() {
		return errorMessage;
	}

	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}

	public boolean isFinalSucceed() {
		return finalSucceed;
	}

	public void setFinalSucceed(boolean finalSucceed) {
		this.finalSucceed = finalSucceed;
	}
}
