package in.clouthink.daas.bm.domain.service;

import in.clouthink.daas.bm.core.MessageReceiver;
import in.clouthink.daas.bm.domain.model.BusinessMessage;
import in.clouthink.daas.bm.domain.model.FailureMessage;
import in.clouthink.daas.bm.domain.request.BusinessMessageQueryRequest;
import in.clouthink.daas.bm.domain.request.FailureMessageQueryRequest;
import org.springframework.data.domain.Page;

/**
 * The service interface for the domain application
 *
 * @author dz
 */
public interface BusinessMessageService {

	/**
	 * Persist the business message
	 *
	 * @param message
	 * @return
	 */
	BusinessMessage saveBusinessMessage(BusinessMessage message);

	/**
	 * @param messageId
	 * @return
	 */
	BusinessMessage findBusinessMessageById(String messageId);

	/**
	 * @param queryRequest
	 * @return
	 */
	Page<BusinessMessage> listBusinessMessages(BusinessMessageQueryRequest queryRequest);

	/**
	 * @param messageId
	 * @param receiver  must be the owner of the message
	 */
	void markAsRead(String messageId, MessageReceiver receiver);

	/**
	 * @param messageId
	 * @param receiver  must be the owner of the message
	 */
	void markAsProcessed(String messageId, MessageReceiver receiver);

	/**
	 * The implementation can just mark the message as deleted ,
	 * or delete it physically is also allowed.
	 *
	 * @param messageId
	 * @param receiver  must be the owner of the message
	 */
	void deleteBusinessMessage(String messageId, MessageReceiver receiver);

	/**
	 * @param messageId
	 * @return
	 */
	FailureMessage findFailureMessageById(String messageId);

	/**
	 * @param queryRequest
	 * @return
	 */
	Page<FailureMessage> listFailureMessages(FailureMessageQueryRequest queryRequest);

	/**
	 * The implementation can just mark the message as deleted ,
	 * or delete it physically is also allowed.
	 *
	 * @param messageId
	 * @return
	 */
	FailureMessage deleteFailureMessage(String messageId);

}
