/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.bm.core.impl;

import in.clouthink.daas.bm.core.BusinessMessageManager;
import in.clouthink.daas.bm.core.BusinessMessageRequest;
import in.clouthink.daas.bm.core.BusinessMessageRequestHandler;
import in.clouthink.daas.bm.core.BusinessMessageResponseHandler;
import in.clouthink.daas.bm.core.BusinessMessageTarget;
import in.clouthink.daas.bm.core.BusinessMessageTargetParser;
import in.clouthink.daas.bm.core.MessageReceiver;
import in.clouthink.daas.bm.core.impl.BusinessMessageTargetParserImpl;
import in.clouthink.daas.bm.core.impl.DummyBusinessMessageRequestHandler;
import in.clouthink.daas.bm.core.impl.DummyBusinessMessageResponseHandler;

public class BusinessMessageManagerImpl
implements BusinessMessageManager {
    private BusinessMessageTargetParser parser = new BusinessMessageTargetParserImpl();
    private BusinessMessageRequestHandler requestHandler = new DummyBusinessMessageRequestHandler();
    private BusinessMessageResponseHandler responseHandler = new DummyBusinessMessageResponseHandler();

    @Override
    public void register(BusinessMessageResponseHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.responseHandler = handler;
    }

    @Override
    public void register(BusinessMessageTargetParser parser) {
        if (parser == null) {
            throw new NullPointerException();
        }
        this.parser = parser;
    }

    @Override
    public void register(BusinessMessageRequestHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.requestHandler = handler;
    }

    @Override
    public void process(String target, BusinessMessageRequest request) {
        if (target == null) {
            throw new NullPointerException();
        }
        Iterable<BusinessMessageTarget> targetIterable = this.parser.parse(target);
        for (BusinessMessageTarget businessMessageTarget : targetIterable) {
            this.doValidate(businessMessageTarget);
        }
        for (BusinessMessageTarget businessMessageTarget : targetIterable) {
            this.requestHandler.onRequest(businessMessageTarget, request, this.responseHandler);
        }
    }

    protected void doValidate(BusinessMessageTarget businessMessageTarget) {
    }

    @Override
    public void process(MessageReceiver receiver, BusinessMessageRequest request) {
        if (receiver == null) {
            throw new NullPointerException();
        }
        this.requestHandler.onRequest(receiver, request, this.responseHandler);
    }
}

