/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.bm.core.impl;

import in.clouthink.daas.bm.core.BusinessMessageRequest;
import in.clouthink.daas.bm.core.BusinessMessageRequestHandler;
import in.clouthink.daas.bm.core.BusinessMessageResponseHandler;
import in.clouthink.daas.bm.core.BusinessMessageTarget;
import in.clouthink.daas.bm.core.MessageReceiver;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompositeBusinessMessageRequestHandler
implements BusinessMessageRequestHandler {
    private static final Log logger = LogFactory.getLog(CompositeBusinessMessageRequestHandler.class);
    private List<BusinessMessageRequestHandler> handlers = new ArrayList<BusinessMessageRequestHandler>();

    public void addHandler(BusinessMessageRequestHandler handler) {
        this.handlers.add(handler);
    }

    public void removeHandler(BusinessMessageRequestHandler handler) {
        this.handlers.remove(handler);
    }

    public void onRequest(MessageReceiver messageReceiver, BusinessMessageRequest messageRequest, BusinessMessageResponseHandler responseHandler) {
        for (BusinessMessageRequestHandler handler : this.handlers) {
            try {
                handler.onRequest(messageReceiver, messageRequest, responseHandler);
            }
            catch (Throwable e) {
                logger.error((Object)"Handle request failed.", e);
            }
        }
    }

    public void onRequest(BusinessMessageTarget messageTarget, BusinessMessageRequest messageRequest, BusinessMessageResponseHandler responseHandler) {
        for (BusinessMessageRequestHandler handler : this.handlers) {
            try {
                handler.onRequest(messageTarget, messageRequest, responseHandler);
            }
            catch (Throwable e) {
                logger.error((Object)"Handle request failed.", e);
            }
        }
    }
}

