/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.bm.domain.rest;

import in.clouthink.daas.bm.domain.model.FailureMessage;
import in.clouthink.daas.bm.domain.request.FailureMessageQueryParameter;
import in.clouthink.daas.bm.domain.rest.FailureMessageDetail;
import in.clouthink.daas.bm.domain.rest.FailureMessageRestSupport;
import in.clouthink.daas.bm.domain.rest.FailureMessageSummary;
import in.clouthink.daas.bm.domain.service.BusinessMessageService;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class DefaultFailureMessageRestSupport
implements FailureMessageRestSupport {
    @Autowired
    private BusinessMessageService businessMessageService;

    @Override
    public FailureMessageDetail getFailureMessageDetail(String id) {
        return FailureMessageDetail.from(this.businessMessageService.findFailureMessageById(id));
    }

    @Override
    public Page<FailureMessageSummary> listFailureMessagePage(FailureMessageQueryParameter request) {
        Page<FailureMessage> failureMessagePage = this.businessMessageService.listFailureMessages(request);
        return new PageImpl(failureMessagePage.getContent().stream().map(FailureMessageSummary::from).collect(Collectors.toList()), (Pageable)new PageRequest(request.getStart(), request.getLimit()), failureMessagePage.getTotalElements());
    }

    @Override
    public FailureMessageDetail deleteFailureMessage(String id) {
        return FailureMessageDetail.from(this.businessMessageService.deleteFailureMessage(id));
    }
}

