package in.clouthink.daas.bm.core.impl;

import in.clouthink.daas.bm.core.*;

public class BusinessMessageManagerImpl implements BusinessMessageManager {

	private BusinessMessageTargetParser parser = new BusinessMessageTargetParserImpl();

	private BusinessMessageRequestHandler requestHandler = new DummyBusinessMessageRequestHandler();

	private BusinessMessageResponseHandler responseHandler = new DummyBusinessMessageResponseHandler();

	@Override
	public void register(BusinessMessageResponseHandler handler) {
		if (handler == null) {
			throw new NullPointerException();
		}
		this.responseHandler = handler;
	}

	@Override
	public void register(BusinessMessageTargetParser parser) {
		if (parser == null) {
			throw new NullPointerException();
		}
		this.parser = parser;
	}

	@Override
	public void register(BusinessMessageRequestHandler handler) {
		if (handler == null) {
			throw new NullPointerException();
		}
		this.requestHandler = handler;
	}

	@Override
	public void process(String target, BusinessMessageRequest request) {
		if (target == null) {
			throw new NullPointerException();
		}
		Iterable<BusinessMessageTarget> targetIterable = parser.parse(target);
		for (BusinessMessageTarget businessMessageTarget : targetIterable) {
			doValidate(businessMessageTarget);
		}

		for (BusinessMessageTarget businessMessageTarget : targetIterable) {
			requestHandler.onRequest(businessMessageTarget, request, responseHandler);
		}
	}

	protected void doValidate(BusinessMessageTarget businessMessageTarget) {
	}

	@Override
	public void process(MessageReceiver receiver, BusinessMessageRequest request) {
		if (receiver == null) {
			throw new NullPointerException();
		}
		requestHandler.onRequest(receiver, request, responseHandler);
	}

}
