package in.clouthink.daas.bm.core.impl;

import in.clouthink.daas.bm.core.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;

/**
 * The composite request handler which handle the request one by one.
 *
 * @author dz
 */
public class CompositeBusinessMessageRequestHandler implements BusinessMessageRequestHandler {

	private static final Log logger = LogFactory.getLog(CompositeBusinessMessageRequestHandler.class);

	private List<BusinessMessageRequestHandler> handlers = new ArrayList<>();

	public void addHandler(BusinessMessageRequestHandler handler) {
		this.handlers.add(handler);
	}

	public void removeHandler(BusinessMessageRequestHandler handler) {
		this.handlers.remove(handler);
	}

	@Override
	public void onRequest(MessageReceiver messageReceiver,
						  BusinessMessageRequest messageRequest,
						  BusinessMessageResponseHandler responseHandler) {
		for (BusinessMessageRequestHandler handler : handlers) {
			try {
				handler.onRequest(messageReceiver, messageRequest, responseHandler);
			}
			catch (Throwable e) {
				logger.error("Handle request failed.", e);
			}
		}
	}

	@Override
	public void onRequest(BusinessMessageTarget messageTarget,
						  BusinessMessageRequest messageRequest,
						  BusinessMessageResponseHandler responseHandler) {
		for (BusinessMessageRequestHandler handler : handlers) {
			try {
				handler.onRequest(messageTarget, messageRequest, responseHandler);
			}
			catch (Throwable e) {
				logger.error("Handle request failed.", e);
			}
		}
	}

}
