package in.clouthink.daas.bm.domain.rest;

import in.clouthink.daas.bm.domain.model.BusinessMessage;
import org.springframework.beans.BeanUtils;

import java.util.Date;
import java.util.Map;

/**
 * @author dz
 */
public class BusinessMessageDetail extends BusinessMessageSummary {

	public static BusinessMessageDetail from(BusinessMessage from) {
		if (from == null) {
			return null;
		}
		BusinessMessageDetail result = new BusinessMessageDetail();
		convert(from, result);
		return result;
	}

	public static void convert(BusinessMessage from, BusinessMessageDetail result) {
		BeanUtils.copyProperties(from, result);
	}

	private Date processedAt;

	private Date deletedAt;

	private Date readAt;

	private String body;

	private Map<String,Object> attributes;

	private Map<String,Object> processedAttributes;

	public Date getProcessedAt() {
		return processedAt;
	}

	public void setProcessedAt(Date processedAt) {
		this.processedAt = processedAt;
	}

	public Date getDeletedAt() {
		return deletedAt;
	}

	public void setDeletedAt(Date deletedAt) {
		this.deletedAt = deletedAt;
	}

	public Date getReadAt() {
		return readAt;
	}

	public void setReadAt(Date readAt) {
		this.readAt = readAt;
	}

	public String getBody() {
		return body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	public Map<String,Object> getAttributes() {
		return attributes;
	}

	public void setAttributes(Map<String,Object> attributes) {
		this.attributes = attributes;
	}

	public Map<String,Object> getProcessedAttributes() {
		return processedAttributes;
	}

	public void setProcessedAttributes(Map<String,Object> processedAttributes) {
		this.processedAttributes = processedAttributes;
	}

}
