package in.clouthink.daas.bm.domain.rest;

import in.clouthink.daas.bm.domain.model.FailureMessage;
import in.clouthink.daas.bm.domain.request.FailureMessageQueryParameter;
import in.clouthink.daas.bm.domain.service.BusinessMessageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;

import java.util.stream.Collectors;

/**
 * @author dz
 */
@Component
public class DefaultFailureMessageRestSupport implements
                                              FailureMessageRestSupport {
                                              
    @Autowired
    private BusinessMessageService businessMessageService;
    
    @Override
    public FailureMessageDetail getFailureMessageDetail(String id) {
        return FailureMessageDetail.from(businessMessageService.findFailureMessageById(id));
    }
    
    @Override
    public Page<FailureMessageSummary> listFailureMessagePage(FailureMessageQueryParameter request) {
        Page<FailureMessage> failureMessagePage = businessMessageService.listFailureMessages(request);
        return new PageImpl<>(failureMessagePage.getContent()
                                                .stream()
                                                .map(FailureMessageSummary::from)
                                                .collect(Collectors.toList()),
                              new PageRequest(request.getStart(),
                                              request.getLimit()),
                              failureMessagePage.getTotalElements());
    }
    
    @Override
    public FailureMessageDetail deleteFailureMessage(String id) {
        return FailureMessageDetail.from(businessMessageService.deleteFailureMessage(id));
    }
}
