package in.clouthink.daas.bm.domain.rest;

import in.clouthink.daas.bm.domain.model.FailureMessage;
import org.springframework.beans.BeanUtils;

import java.util.Map;

/**
 * @author dz
 */
public class FailureMessageDetail extends FailureMessageSummary {

	public static FailureMessageDetail from(FailureMessage from) {
		if (from == null) {
			return null;
		}
		FailureMessageDetail result = new FailureMessageDetail();
		convert(from, result);
		return result;
	}

	public static void convert(FailureMessage from, FailureMessageDetail result) {
		BeanUtils.copyProperties(from, result);
	}

	/**
	 * @return the message body
	 */
	String body;

	/**
	 * @return
	 */
	Map<String,?> attributes;

	/**
	 * @return the latest error message in detail
	 */
	String debugMessage;

	public String getBody() {
		return body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	public Map<String,?> getAttributes() {
		return attributes;
	}

	public void setAttributes(Map<String,?> attributes) {
		this.attributes = attributes;
	}

	public String getDebugMessage() {
		return debugMessage;
	}

	public void setDebugMessage(String debugMessage) {
		this.debugMessage = debugMessage;
	}
}
