package in.clouthink.daas.bm.security;


import in.clouthink.daas.bm.core.MessageReceiver;
import in.clouthink.daas.bm.domain.model.BusinessMessage;

/**
 * The security context for business message
 * <ul>
 * <li>get current principal which is access the business message service</li>
 * <li>make decision whether current principal is the same receiver of business message </li>
 * <li>convert current principal as message sender </li>
 * </ul>
 */
public interface SecurityContext<T> {

	/**
	 * Get current principal which may be the user of audit event
	 *
	 * @return
	 */
	T getPrincipal();

	/**
	 * @param businessMessage
	 * @param principal
	 * @return true if the supplied principal is the same user ( sendTo )  as the owner of business message
	 */
	boolean isReceiver(BusinessMessage businessMessage, T principal);

	/**
	 * convert current principal to message receiver
	 *
	 * @return
	 */
	MessageReceiver asReceiver();

}
