/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.bm.domain.rest;

import in.clouthink.daas.bm.core.MessageReceiver;
import in.clouthink.daas.bm.domain.model.BusinessMessage;
import in.clouthink.daas.bm.domain.request.BusinessMessageQueryParameter;
import in.clouthink.daas.bm.domain.rest.BusinessMessageDetail;
import in.clouthink.daas.bm.domain.rest.BusinessMessageRestSupport;
import in.clouthink.daas.bm.domain.rest.BusinessMessageSummary;
import in.clouthink.daas.bm.domain.service.BusinessMessageService;
import in.clouthink.daas.bm.exception.BusinessMessagePermissionException;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class DefaultBusinessMessageRestSupport
implements BusinessMessageRestSupport {
    @Autowired
    private BusinessMessageService businessMessageService;

    @Override
    public BusinessMessageDetail getBusinessMessageDetail(String id, MessageReceiver receiver) {
        BusinessMessage businessMessage = this.businessMessageService.findBusinessMessageById(id);
        if (businessMessage == null) {
            return null;
        }
        if (!receiver.getId().equals(businessMessage.getReceiverId())) {
            throw new BusinessMessagePermissionException("Illegal access.");
        }
        return BusinessMessageDetail.from(businessMessage);
    }

    @Override
    public Page<BusinessMessageSummary> listBusinessMessagePage(BusinessMessageQueryParameter request, MessageReceiver receiver) {
        request.setDeleted(false);
        request.setReceiverId(receiver.getId());
        request.setReceiverName(null);
        Page<BusinessMessage> businessMessagePage = this.businessMessageService.listBusinessMessages(request);
        return new PageImpl(businessMessagePage.getContent().stream().map(BusinessMessageSummary::from).collect(Collectors.toList()), (Pageable)new PageRequest(request.getStart(), request.getLimit()), businessMessagePage.getTotalElements());
    }

    @Override
    public void readBusinessMessage(String id, MessageReceiver receiver) {
        this.businessMessageService.markAsRead(id, receiver);
    }

    @Override
    public void processBusinessMessage(String id, Map<String, String> processedAttributes, MessageReceiver receiver) {
        this.businessMessageService.markAsProcessed(id, processedAttributes, receiver);
    }

    @Override
    public void deleteBusinessMessage(String id, MessageReceiver receiver) {
        this.businessMessageService.deleteBusinessMessage(id, receiver);
    }
}

