package in.clouthink.daas.bm.support.mongodb.model;

import in.clouthink.daas.bm.core.BusinessMessageRequest;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Document(collection = "BusinessMessages")
public class BusinessMessageEntity implements in.clouthink.daas.bm.domain.model.BusinessMessage<String> {

	public static BusinessMessageEntity from(BusinessMessageRequest request) {
		BusinessMessageEntity result = new BusinessMessageEntity();
		result.setCategory(request.getCategory());
		result.setTitle(request.getTitle());
		if (request.getBody() != null) {
			result.setBody(request.getBody().toString());
		}
		result.setAttributes(request.getAttributes());
		if (request.getCode() != null) {
			if (result.getAttributes() == null) {
				result.setAttributes(new HashMap<>());
			}
			result.getAttributes().put("__code", request.getCode());
		}
		result.setProcessed(false);
		result.setRead(false);
		result.setDeleted(false);
		if (request.getSender() != null) {
			result.setSenderId(request.getSender().getId());
			result.setSenderType(request.getSender().getType());
			result.setSenderName(request.getSender().getName());
		}
		return result;
	}

	@Id
	private String id;

	private String category;

	private String title;

	private String body;

	private Map<String,Object> attributes;

	@Indexed
	private String receiverId;

	private String receiverType;

	private String receiverName;

	private String senderId;

	private String senderType;

	private String senderName;

	private Date sendAt;

	private boolean read;

	private Date readAt;

	private boolean processed;

	private Date processedAt;

	@Indexed
	private boolean deleted;

	private Date deletedAt;

	@Override
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@Override
	public String getCategory() {
		return category;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	@Override
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	@Override
	public String getBody() {
		return body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	@Override
	public Map<String,Object> getAttributes() {
		return attributes;
	}

	public void setAttributes(Map<String,Object> attributes) {
		this.attributes = attributes;
	}

	@Override
	public String getReceiverId() {
		return receiverId;
	}

	public void setReceiverId(String receiverId) {
		this.receiverId = receiverId;
	}

	@Override
	public String getReceiverType() {
		return receiverType;
	}

	public void setReceiverType(String receiverType) {
		this.receiverType = receiverType;
	}

	@Override
	public String getReceiverName() {
		return receiverName;
	}

	public void setReceiverName(String receiverName) {
		this.receiverName = receiverName;
	}

	@Override
	public String getSenderId() {
		return senderId;
	}

	public void setSenderId(String senderId) {
		this.senderId = senderId;
	}

	@Override
	public String getSenderType() {
		return senderType;
	}

	public void setSenderType(String senderType) {
		this.senderType = senderType;
	}

	@Override
	public String getSenderName() {
		return senderName;
	}

	public void setSenderName(String senderName) {
		this.senderName = senderName;
	}

	@Override
	public Date getSendAt() {
		return sendAt;
	}

	public void setSendAt(Date sendAt) {
		this.sendAt = sendAt;
	}

	@Override
	public boolean isRead() {
		return read;
	}

	public void setRead(boolean read) {
		this.read = read;
	}

	@Override
	public boolean isProcessed() {
		return processed;
	}

	public void setProcessed(boolean processed) {
		this.processed = processed;
	}

	@Override
	public boolean isDeleted() {
		return deleted;
	}

	public void setDeleted(boolean deleted) {
		this.deleted = deleted;
	}

	@Override
	public Date getReadAt() {
		return readAt;
	}

	public void setReadAt(Date readAt) {
		this.readAt = readAt;
	}

	@Override
	public Date getProcessedAt() {
		return processedAt;
	}

	public void setProcessedAt(Date processedAt) {
		this.processedAt = processedAt;
	}

	@Override
	public Date getDeletedAt() {
		return deletedAt;
	}

	public void setDeletedAt(Date deletedAt) {
		this.deletedAt = deletedAt;
	}

}
