package in.clouthink.daas.bm.support.mongodb.repository.custom.impl;

import in.clouthink.daas.bm.domain.request.FailureMessageQueryRequest;
import in.clouthink.daas.bm.support.mongodb.model.FailureMessageEntity;
import in.clouthink.daas.bm.support.mongodb.repository.custom.FailureMessageRepositoryCustom;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import java.util.List;

import static org.springframework.data.mongodb.core.query.Criteria.where;

@Repository
public class FailureMessageRepositoryImpl implements FailureMessageRepositoryCustom {

	@Autowired
	protected MongoTemplate mongoTemplate;

	@Override
	public Page<FailureMessageEntity> queryPage(FailureMessageQueryRequest queryRequest) {
		Query query = buildQuery(queryRequest);

		long count = mongoTemplate.count(query, FailureMessageEntity.class);

		int start = queryRequest.getStart();
		int limit = queryRequest.getLimit();

		PageRequest pageable = new PageRequest(start, limit, new Sort(Sort.Direction.DESC, "sendAt"));
		query.with(pageable);

		List<FailureMessageEntity> list = mongoTemplate.find(query, FailureMessageEntity.class);

		return new PageImpl<>(list, pageable, count);
	}

	private Query buildQuery(FailureMessageQueryRequest queryRequest) {
		Query query = new Query();

		if (null != queryRequest.getType()) {
			query.addCriteria(where("type").is(queryRequest.getType()));
		}

		if (!StringUtils.isEmpty(queryRequest.getCategory())) {
			query.addCriteria(where("category").is(queryRequest.getCategory()));
		}

		if (!StringUtils.isEmpty(queryRequest.getTitle())) {
			query.addCriteria(where("title").regex(queryRequest.getTitle()));
		}

		if (!StringUtils.isEmpty(queryRequest.getTarget())) {
			query.addCriteria(where("target").regex(queryRequest.getTarget()));
		}

		if (queryRequest.getBeginDate() != null && queryRequest.getEndDate() != null) {
			query.addCriteria(new Criteria().andOperator(Criteria.where("createAt").gte(queryRequest.getBeginDate()),
														 Criteria.where("createAt").lte(queryRequest.getEndDate())));
		}
		else if (queryRequest.getBeginDate() != null) {
			query.addCriteria(Criteria.where("createAt").gte(queryRequest.getBeginDate()));
		}
		else if (queryRequest.getEndDate() != null) {
			query.addCriteria(Criteria.where("createAt").lte(queryRequest.getEndDate()));
		}

		return query;
	}

}
