package in.clouthink.daas.bm.support.mongodb.spiImpl;

import in.clouthink.daas.bm.core.*;
import in.clouthink.daas.bm.support.mongodb.model.BusinessMessageEntity;
import in.clouthink.daas.edm.Edms;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.Date;

/**
 * The dummy impl.
 */
public class BusinessMessageRequestMongodbHandler implements BusinessMessageRequestHandler {

	private static final Log logger = LogFactory.getLog(BusinessMessageRequestMongodbHandler.class);

	@Override
	public void onRequest(MessageReceiver messageReceiver,
						  BusinessMessageRequest request,
						  BusinessMessageResponseHandler handler) {
		BusinessMessageEntity businessMessageEntity = BusinessMessageEntity.from(request);
		businessMessageEntity.setReceiverId(messageReceiver.getId());
		businessMessageEntity.setReceiverType(messageReceiver.getType());
		businessMessageEntity.setReceiverName(messageReceiver.getName());
		businessMessageEntity.setSendAt(new Date());

		Edms.getEdm("bm").dispatch("mongodb/single", businessMessageEntity);
	}

	@Override
	public void onRequest(BusinessMessageTarget target,
						  BusinessMessageRequest request,
						  BusinessMessageResponseHandler handler) {
		Edms.getEdm("bm").dispatch("mongodb/batch", new BusinessMessageBatchRequest(target, request));
	}

}
