/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.bm.support.mongodb;

import in.clouthink.daas.bm.core.BusinessMessageRequestHandler;
import in.clouthink.daas.bm.core.MessageReceiverResolver;
import in.clouthink.daas.bm.domain.service.BusinessMessageService;
import in.clouthink.daas.bm.support.mongodb.spiImpl.BusinessMessageBatchHandler;
import in.clouthink.daas.bm.support.mongodb.spiImpl.BusinessMessageBuilder;
import in.clouthink.daas.bm.support.mongodb.spiImpl.BusinessMessageRequestMongodbHandler;
import in.clouthink.daas.bm.support.mongodb.spiImpl.BusinessMessageServiceImpl;
import in.clouthink.daas.edm.Edms;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

@Configuration
@ComponentScan(value={"in.clouthink.daas.bm.support.mongodb"})
@EnableMongoRepositories(value={"in.clouthink.daas.bm.support.mongodb.repository"})
public class MongoModuleConfiguration
implements InitializingBean {
    @Autowired
    private BusinessMessageService businessMessageService;
    @Autowired
    private BusinessMessageBatchHandler businessMessageBatchHandler;

    @Bean
    public BusinessMessageService businessMessageService() {
        return new BusinessMessageServiceImpl();
    }

    @Bean
    @Autowired
    public BusinessMessageBuilder businessMessageBuilder(MessageReceiverResolver messageReceiverResolver) {
        return new BusinessMessageBuilder(messageReceiverResolver);
    }

    @Bean
    @Autowired
    public BusinessMessageBatchHandler BusinessMessageBatchHandler(BusinessMessageService businessMessageService, BusinessMessageBuilder businessMessageBuilder) {
        return new BusinessMessageBatchHandler(businessMessageService, businessMessageBuilder);
    }

    @Bean(name={"businessMessageRequestMongodbHandler"})
    @Autowired
    public BusinessMessageRequestHandler businessMessageRequestMongodbHandler() {
        return new BusinessMessageRequestMongodbHandler();
    }

    public void afterPropertiesSet() throws Exception {
        Edms.getEdm((String)"bm").register("mongodb/single", (Object)this.businessMessageService);
        Edms.getEdm((String)"bm").register("mongodb/batch", (Object)this.businessMessageBatchHandler);
    }
}

