/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.bm.support.mongodb.repository.custom.impl;

import in.clouthink.daas.bm.domain.request.BusinessMessageQueryRequest;
import in.clouthink.daas.bm.support.mongodb.model.BusinessMessageEntity;
import in.clouthink.daas.bm.support.mongodb.repository.custom.BusinessMessageRepositoryCustom;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class BusinessMessageRepositoryImpl
implements BusinessMessageRepositoryCustom {
    @Autowired
    protected MongoTemplate mongoTemplate;

    @Override
    public long count(BusinessMessageQueryRequest queryRequest) {
        Query query = this.buildQuery(queryRequest);
        return this.mongoTemplate.count(query, BusinessMessageEntity.class);
    }

    @Override
    public Page<BusinessMessageEntity> queryPage(BusinessMessageQueryRequest queryRequest) {
        Query query = this.buildQuery(queryRequest);
        long count = this.mongoTemplate.count(query, BusinessMessageEntity.class);
        int start = queryRequest.getStart();
        int limit = queryRequest.getLimit();
        PageRequest pageable = new PageRequest(start, limit, new Sort(Sort.Direction.DESC, new String[]{"sendAt"}));
        query.with((Pageable)pageable);
        List list = this.mongoTemplate.find(query, BusinessMessageEntity.class);
        return new PageImpl(list, (Pageable)pageable, count);
    }

    @Override
    public void markAsRead(String id) {
        this.mongoTemplate.updateFirst(Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id)), new Update().set("read", (Object)true).set("readAt", (Object)new Date()), BusinessMessageEntity.class);
    }

    @Override
    public void markAsProcessed(String id) {
        this.mongoTemplate.updateFirst(Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id)), new Update().set("processed", (Object)true).set("processAt", (Object)new Date()), BusinessMessageEntity.class);
    }

    @Override
    public void markAsDeleted(String id) {
        this.mongoTemplate.updateFirst(Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id)), new Update().set("deleted", (Object)true).set("deleteAt", (Object)new Date()), BusinessMessageEntity.class);
    }

    private Query buildQuery(BusinessMessageQueryRequest queryRequest) {
        Query query = new Query();
        if (!StringUtils.isEmpty((Object)queryRequest.getCategory())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"category").regex(queryRequest.getCategory()));
        }
        if (queryRequest.getReceiverId() != null) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"receiverId").is((Object)queryRequest.getReceiverId()));
        }
        if (!StringUtils.isEmpty((Object)queryRequest.getReceiverName())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"receiverName").regex(queryRequest.getReceiverName()));
        }
        if (queryRequest.getRead() != null) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"read").ne((Object)(queryRequest.getRead() == false ? 1 : 0)));
        }
        if (queryRequest.getDeleted() != null) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"deleted").ne((Object)(queryRequest.getDeleted() == false ? 1 : 0)));
        }
        if (queryRequest.getBeginDate() != null && queryRequest.getEndDate() != null) {
            query.addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"sendAt").gte((Object)queryRequest.getBeginDate()), Criteria.where((String)"sendAt").lte((Object)queryRequest.getEndDate())}));
        } else if (queryRequest.getBeginDate() != null) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"sendAt").gte((Object)queryRequest.getBeginDate()));
        } else if (queryRequest.getEndDate() != null) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"sendAt").lte((Object)queryRequest.getEndDate()));
        }
        return query;
    }
}

