/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.bm.support.mongodb.spiImpl;

import in.clouthink.daas.bm.core.BusinessMessageRequest;
import in.clouthink.daas.bm.core.BusinessMessageTarget;
import in.clouthink.daas.bm.core.BusinessMessageVisitable;
import in.clouthink.daas.bm.core.BusinessMessageVisitableBuilder;
import in.clouthink.daas.bm.core.MessageReceiverResolver;
import in.clouthink.daas.bm.domain.model.BusinessMessage;
import in.clouthink.daas.bm.support.mongodb.model.BusinessMessageEntity;
import java.util.Date;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class BusinessMessageBuilder
implements BusinessMessageVisitableBuilder,
InitializingBean {
    private MessageReceiverResolver messageReceiverResolver;

    public BusinessMessageBuilder() {
    }

    public BusinessMessageBuilder(MessageReceiverResolver messageReceiverResolver) {
        this.messageReceiverResolver = messageReceiverResolver;
    }

    public void setMessageReceiverResolver(MessageReceiverResolver messageReceiverResolver) {
        if (messageReceiverResolver == null) {
            throw new NullPointerException();
        }
        this.messageReceiverResolver = messageReceiverResolver;
    }

    public BusinessMessageVisitable build(BusinessMessageTarget target, BusinessMessageRequest request) {
        return messageVisitor -> this.messageReceiverResolver.resolve(target).accept(messageReceiver -> {
            BusinessMessageEntity entity = BusinessMessageEntity.from(request);
            entity.setReceiverId(messageReceiver.getId());
            entity.setReceiverType(messageReceiver.getType());
            entity.setReceiverName(messageReceiver.getName());
            entity.setSendAt(new Date());
            messageVisitor.visit((BusinessMessage)entity);
        });
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.messageReceiverResolver);
    }
}

