/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.bm.support.mongodb.spiImpl;

import in.clouthink.daas.bm.core.MessageReceiver;
import in.clouthink.daas.bm.domain.model.BusinessMessage;
import in.clouthink.daas.bm.domain.model.FailureMessage;
import in.clouthink.daas.bm.domain.request.BusinessMessageQueryRequest;
import in.clouthink.daas.bm.domain.request.FailureMessageQueryRequest;
import in.clouthink.daas.bm.domain.service.BusinessMessageService;
import in.clouthink.daas.bm.exception.BusinessMessageNotFoundException;
import in.clouthink.daas.bm.exception.BusinessMessagePermissionException;
import in.clouthink.daas.bm.support.mongodb.model.BusinessMessageEntity;
import in.clouthink.daas.bm.support.mongodb.model.FailureMessageEntity;
import in.clouthink.daas.bm.support.mongodb.repository.BusinessMessageRepository;
import in.clouthink.daas.bm.support.mongodb.repository.FailureMessageRepository;
import in.clouthink.daas.edm.Listenable;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class BusinessMessageServiceImpl
implements BusinessMessageService {
    @Autowired
    private BusinessMessageRepository businessMessageRepository;
    @Autowired
    private FailureMessageRepository failureMessageRepository;

    @Listenable
    public BusinessMessage saveBusinessMessage(BusinessMessage message) {
        if (message instanceof BusinessMessageEntity) {
            return (BusinessMessage)this.businessMessageRepository.save((BusinessMessageEntity)message);
        }
        BusinessMessageEntity entity = new BusinessMessageEntity();
        BeanUtils.copyProperties((Object)message, (Object)entity);
        return (BusinessMessage)this.businessMessageRepository.save(entity);
    }

    public BusinessMessage findBusinessMessageById(String messageId) {
        return (BusinessMessage)this.businessMessageRepository.findById(messageId);
    }

    public Page<BusinessMessage> listBusinessMessages(BusinessMessageQueryRequest queryRequest) {
        Page resultPage = this.businessMessageRepository.queryPage(queryRequest);
        return new PageImpl(resultPage.getContent().stream().map(item -> item).collect(Collectors.toList()), (Pageable)new PageRequest(queryRequest.getStart(), queryRequest.getLimit()), resultPage.getTotalElements());
    }

    public void markAsRead(String messageId, MessageReceiver receiver) {
        if (receiver == null) {
            throw new BusinessMessagePermissionException("Illegal access.");
        }
        BusinessMessageEntity businessMessageEntity = (BusinessMessageEntity)this.businessMessageRepository.findById(messageId);
        if (businessMessageEntity == null) {
            throw new BusinessMessageNotFoundException();
        }
        if (!receiver.getId().equals(businessMessageEntity.getReceiverId())) {
            throw new BusinessMessagePermissionException("Illegal access.");
        }
        this.businessMessageRepository.markAsRead(messageId);
    }

    public void markAsProcessed(String messageId, MessageReceiver receiver) {
        if (receiver == null) {
            throw new BusinessMessagePermissionException("Illegal access.");
        }
        BusinessMessageEntity businessMessageEntity = (BusinessMessageEntity)this.businessMessageRepository.findById(messageId);
        if (businessMessageEntity == null) {
            throw new BusinessMessageNotFoundException();
        }
        if (!receiver.getId().equals(businessMessageEntity.getReceiverId())) {
            throw new BusinessMessagePermissionException("Illegal access.");
        }
        this.businessMessageRepository.markAsProcessed(messageId);
    }

    public void deleteBusinessMessage(String messageId, MessageReceiver receiver) {
        if (receiver == null) {
            throw new BusinessMessagePermissionException("Illegal access.");
        }
        BusinessMessageEntity businessMessageEntity = (BusinessMessageEntity)this.businessMessageRepository.findById(messageId);
        if (businessMessageEntity == null) {
            throw new BusinessMessageNotFoundException();
        }
        if (!receiver.getId().equals(businessMessageEntity.getReceiverId())) {
            throw new BusinessMessagePermissionException("Illegal access.");
        }
        this.businessMessageRepository.markAsDeleted(messageId);
    }

    public FailureMessage findFailureMessageById(String messageId) {
        return (FailureMessage)this.failureMessageRepository.findById(messageId);
    }

    public Page<FailureMessage> listFailureMessages(FailureMessageQueryRequest queryRequest) {
        Page resultPage = this.failureMessageRepository.queryPage(queryRequest);
        return new PageImpl(resultPage.getContent().stream().map(item -> item).collect(Collectors.toList()), (Pageable)new PageRequest(queryRequest.getStart(), queryRequest.getLimit()), resultPage.getTotalElements());
    }

    public FailureMessage deleteFailureMessage(String messageId) {
        FailureMessageEntity result = (FailureMessageEntity)this.failureMessageRepository.findById(messageId);
        if (result == null) {
            return null;
        }
        this.failureMessageRepository.delete(result);
        return result;
    }
}

