/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.bm.support.mongodb.model;

import in.clouthink.daas.bm.core.BusinessMessageRequest;
import in.clouthink.daas.bm.domain.model.BusinessMessage;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="BusinessMessages")
public class BusinessMessageEntity
implements BusinessMessage<String> {
    @Id
    private String id;
    @Indexed
    private String category;
    private String title;
    private String body;
    private Map<String, Object> attributes;
    @Indexed
    private String receiverId;
    private String receiverType;
    private String receiverName;
    private String senderId;
    private String senderType;
    private String senderName;
    @Indexed
    private Date sendAt;
    private boolean read;
    private Date readAt;
    private boolean processRequired;
    private boolean processed;
    private Date processedAt;
    @Indexed
    private boolean deleted;
    private Date deletedAt;
    private Map<String, Object> processedAttributes;

    public static BusinessMessageEntity from(BusinessMessageRequest request) {
        BusinessMessageEntity result = new BusinessMessageEntity();
        result.setCategory(request.getCategory());
        result.setTitle(request.getTitle());
        if (request.getBody() != null) {
            result.setBody(request.getBody().toString());
        }
        result.setAttributes(request.getAttributes());
        if (request.getCode() != null) {
            if (result.getAttributes() == null) {
                result.setAttributes(new HashMap<String, Object>());
            }
            result.getAttributes().put("__code", request.getCode());
        }
        result.setProcessed(false);
        result.setRead(false);
        result.setDeleted(false);
        if (request.getSender() != null) {
            result.setSenderId(request.getSender().getId());
            result.setSenderType(request.getSender().getType());
            result.setSenderName(request.getSender().getName());
        }
        return result;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public String getReceiverId() {
        return this.receiverId;
    }

    public void setReceiverId(String receiverId) {
        this.receiverId = receiverId;
    }

    public String getReceiverType() {
        return this.receiverType;
    }

    public void setReceiverType(String receiverType) {
        this.receiverType = receiverType;
    }

    public String getReceiverName() {
        return this.receiverName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public void setSenderId(String senderId) {
        this.senderId = senderId;
    }

    public String getSenderType() {
        return this.senderType;
    }

    public void setSenderType(String senderType) {
        this.senderType = senderType;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public Date getSendAt() {
        return this.sendAt;
    }

    public void setSendAt(Date sendAt) {
        this.sendAt = sendAt;
    }

    public boolean isRead() {
        return this.read;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public boolean isProcessRequired() {
        return this.processRequired;
    }

    public void setProcessRequired(boolean processRequired) {
        this.processRequired = processRequired;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public Date getReadAt() {
        return this.readAt;
    }

    public void setReadAt(Date readAt) {
        this.readAt = readAt;
    }

    public Date getProcessedAt() {
        return this.processedAt;
    }

    public void setProcessedAt(Date processedAt) {
        this.processedAt = processedAt;
    }

    public Date getDeletedAt() {
        return this.deletedAt;
    }

    public void setDeletedAt(Date deletedAt) {
        this.deletedAt = deletedAt;
    }

    public Map<String, Object> getProcessedAttributes() {
        return this.processedAttributes;
    }

    public void setProcessedAttributes(Map<String, Object> processedAttributes) {
        this.processedAttributes = processedAttributes;
    }
}

