/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.bm.support.mongodb.repository.custom.impl;

import in.clouthink.daas.bm.domain.request.FailureMessageQueryRequest;
import in.clouthink.daas.bm.support.mongodb.model.FailureMessageEntity;
import in.clouthink.daas.bm.support.mongodb.repository.custom.FailureMessageRepositoryCustom;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class FailureMessageRepositoryImpl
implements FailureMessageRepositoryCustom {
    @Autowired
    protected MongoTemplate mongoTemplate;

    @Override
    public Page<FailureMessageEntity> queryPage(FailureMessageQueryRequest queryRequest) {
        Query query = this.buildQuery(queryRequest);
        long count = this.mongoTemplate.count(query, FailureMessageEntity.class);
        int start = queryRequest.getStart();
        int limit = queryRequest.getLimit();
        PageRequest pageable = new PageRequest(start, limit, new Sort(Sort.Direction.DESC, new String[]{"sendAt"}));
        query.with((Pageable)pageable);
        List list = this.mongoTemplate.find(query, FailureMessageEntity.class);
        return new PageImpl(list, (Pageable)pageable, count);
    }

    private Query buildQuery(FailureMessageQueryRequest queryRequest) {
        Query query = new Query();
        if (null != queryRequest.getType()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)queryRequest.getType()));
        }
        if (!StringUtils.isEmpty((Object)queryRequest.getCategory())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"category").is((Object)queryRequest.getCategory()));
        }
        if (!StringUtils.isEmpty((Object)queryRequest.getTitle())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"title").regex(queryRequest.getTitle()));
        }
        if (!StringUtils.isEmpty((Object)queryRequest.getTarget())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"target").regex(queryRequest.getTarget()));
        }
        if (queryRequest.getBeginDate() != null && queryRequest.getEndDate() != null) {
            query.addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"createAt").gte((Object)queryRequest.getBeginDate()), Criteria.where((String)"createAt").lte((Object)queryRequest.getEndDate())}));
        } else if (queryRequest.getBeginDate() != null) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"createAt").gte((Object)queryRequest.getBeginDate()));
        } else if (queryRequest.getEndDate() != null) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"createAt").lte((Object)queryRequest.getEndDate()));
        }
        return query;
    }
}

