/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.bm.support.mongodb.repository.custom.impl;

import in.clouthink.daas.bm.domain.request.DateRangedQueryRequest;
import in.clouthink.daas.bm.domain.request.PageQueryRequest;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class RepositoryCustomHelper {
    public static PageRequest processPagePart(Query query, PageQueryRequest queryRequest, Sort sort) {
        if (queryRequest instanceof DateRangedQueryRequest) {
            DateRangedQueryRequest dateRangedQueryRequest = (DateRangedQueryRequest)queryRequest;
            if (dateRangedQueryRequest.getBeginDate() != null && dateRangedQueryRequest.getEndDate() != null) {
                query.addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"createdAt").gte((Object)dateRangedQueryRequest.getBeginDate()), Criteria.where((String)"createdAt").lte((Object)dateRangedQueryRequest.getEndDate())}));
            } else if (dateRangedQueryRequest.getBeginDate() != null) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"createdAt").gte((Object)dateRangedQueryRequest.getBeginDate()));
            } else if (dateRangedQueryRequest.getEndDate() != null) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"createdAt").lte((Object)dateRangedQueryRequest.getEndDate()));
            }
        }
        int start = queryRequest.getStart();
        int limit = queryRequest.getLimit();
        PageRequest pageable = new PageRequest(start, limit, sort);
        query.with((Pageable)pageable);
        return pageable;
    }
}

