package in.clouthink.daas.bm.support.push;

import in.clouthink.daas.bm.core.BusinessMessageRequestHandler;
import in.clouthink.daas.bm.support.push.spiImpl.BusinessMessageRequestJPushHandler;
import in.clouthink.daas.edm.Edms;
import in.clouthink.daas.edm.push.PushSender;
import in.clouthink.daas.edm.push.impl.JPushOptions;
import in.clouthink.daas.edm.push.impl.PushSenderJPushImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * The push module configuration for spring boot.
 * Import it or pop it in the Application#run args.
 * <p>
 * The daas edm push is required (lib in classpath and configuration is ready).
 *
 * @author dz
 */
@Configuration
@EnableConfigurationProperties({JPushOptions.class})
public class PushModuleConfiguration {

	@Bean(name = "businessMessageRequestJPushHandler")
	@Autowired
	public BusinessMessageRequestHandler businessMessageRequestJPushHandler() {
		return new BusinessMessageRequestJPushHandler();
	}

	@Bean
	@Autowired
	public PushSender pushSenderJPushImpl(JPushOptions jPushOptions) {
		PushSender result = new PushSenderJPushImpl(jPushOptions);
		Edms.getEdm("push").register("push", result);
		return result;
	}

}