package in.clouthink.daas.bm.support.push.spiImpl;

import in.clouthink.daas.bm.core.*;
import in.clouthink.daas.edm.Edms;
import in.clouthink.daas.edm.push.PushMessage;
import in.clouthink.daas.edm.push.PushType;

import java.util.HashMap;

public class BusinessMessageRequestJPushHandler implements BusinessMessageRequestHandler {

	public BusinessMessageRequestJPushHandler() {
	}


	/**
	 * Send the message through the underlying provider ( for example: jpush).
	 * <p>
	 * The business message will build and save to the repository if sent success,
	 * otherwise the failure message will build and saved.
	 *
	 * @param receiver
	 * @param request
	 * @param handler
	 * @param <T>
	 */
	@Override
	public <T> void onRequest(MessageReceiver receiver,
							  BusinessMessageRequest<T> request,
							  BusinessMessageResponseHandler handler) {
		PushMessage pushMessage = new PushMessage();

		pushMessage.setPushType(PushType.Alias);
		pushMessage.setAlias(new String[]{receiver.getId()});
		pushMessage.setTitle(request.getTitle());
		pushMessage.setContent((String) request.getBody());

		if (pushMessage.getAttributes() == null) {
			pushMessage.setAttributes(new HashMap<String,Object>());
		}
		pushMessage.getAttributes().putAll(request.getAttributes());
		pushMessage.getAttributes().put("__category", request.getCategory());
		pushMessage.getAttributes().put("__code", request.getCode());

		Edms.getEdm("push").dispatch("push", pushMessage);
	}

	/**
	 * Send the message through the underlying provider ( for example: jpush).
	 * <p>
	 * The business message will build and save to the repository if sent success,
	 * otherwise the failure message will build and saved.
	 *
	 * @param target
	 * @param request
	 * @param handler
	 * @param <T>
	 */
	@Override
	public <T> void onRequest(BusinessMessageTarget target,
							  BusinessMessageRequest<T> request,
							  BusinessMessageResponseHandler handler) {
		PushMessage pushMessage = new PushMessage();
		if (BusinessMessageTarget.TYPE_ALL.equalsIgnoreCase(target.getType())) {
			pushMessage.setPushType(PushType.All);
		}
		if (BusinessMessageTarget.TYPE_OR.equalsIgnoreCase(target.getType())) {
			pushMessage.setPushType(PushType.TagOr);
			pushMessage.setTags(target.getValues());
		}
		if (BusinessMessageTarget.TYPE_AND.equalsIgnoreCase(target.getType())) {
			pushMessage.setPushType(PushType.TagAnd);
			pushMessage.setTags(target.getValues());
		}
		if (BusinessMessageTarget.TYPE_ALIAS.equalsIgnoreCase(target.getType())) {
			pushMessage.setPushType(PushType.Alias);
			pushMessage.setAlias(target.getValues());
		}

		pushMessage.setTitle(request.getTitle());
		pushMessage.setContent((String) request.getBody());

		if (pushMessage.getAttributes() == null) {
			pushMessage.setAttributes(new HashMap<String,Object>());
		}
		if (request.getAttributes() != null) {
			pushMessage.getAttributes().putAll(request.getAttributes());
		}
		pushMessage.getAttributes().put("__category", request.getCategory());
		pushMessage.getAttributes().put("__code", request.getCode());

		Edms.getEdm("push").dispatch("push", pushMessage);
	}

	private void checkType(BusinessMessageTarget target) {
		if (!BusinessMessageTarget.TYPE_ALL.equalsIgnoreCase(target.getType()) &&
			!BusinessMessageTarget.TYPE_OR.equalsIgnoreCase(target.getType()) &&
			!BusinessMessageTarget.TYPE_AND.equalsIgnoreCase(target.getType()) &&
			!BusinessMessageTarget.TYPE_ALIAS.equalsIgnoreCase(target.getType())) {
			throw new IllegalArgumentException(String.format("Unsupported target type '%s'", target.getType()));
		}
	}

}
