/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.edm.email.impl;

import in.clouthink.daas.edm.Listenable;
import in.clouthink.daas.edm.email.EmailMessage;
import in.clouthink.daas.edm.email.EmailSender;
import java.util.Date;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessagePreparator;

public class EmailSenderImpl
implements EmailSender {
    private JavaMailSender mailSender;

    public EmailSenderImpl(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    @Override
    @Listenable
    public void send(final EmailMessage emailMessage) {
        this.mailSender.send(new MimeMessagePreparator(){

            public void prepare(MimeMessage message) throws Exception {
                String from = emailMessage.getFrom();
                String sender = emailMessage.getSender();
                String to = emailMessage.getTo();
                String subject = emailMessage.getSubject();
                String body = emailMessage.getMessage();
                InternetAddress fromAddress = new InternetAddress(from, sender);
                message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
                message.setFrom((Address)fromAddress);
                message.setReplyTo(new Address[]{fromAddress});
                message.setSubject(subject);
                message.setSentDate(new Date());
                message.setDataHandler(new DataHandler((Object)body, "text/html; charset=UTF-8"));
            }
        });
    }
}

