/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.edm.push.impl;

import cn.jpush.api.common.resp.APIConnectionException;
import cn.jpush.api.common.resp.APIRequestException;
import cn.jpush.api.push.PushClient;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.Message;
import cn.jpush.api.push.model.Options;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.notification.AndroidNotification;
import cn.jpush.api.push.model.notification.IosNotification;
import cn.jpush.api.push.model.notification.Notification;
import cn.jpush.api.push.model.notification.PlatformNotification;
import com.google.gson.JsonObject;
import in.clouthink.daas.edm.Listenable;
import in.clouthink.daas.edm.push.PushMessage;
import in.clouthink.daas.edm.push.PushResponse;
import in.clouthink.daas.edm.push.PushResponseReceiver;
import in.clouthink.daas.edm.push.PushSender;
import in.clouthink.daas.edm.push.PushWay;
import in.clouthink.daas.edm.push.impl.JPushOptions;
import in.clouthink.daas.edm.push.impl.PushResponseReceiverImpl;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PushSenderJPushImpl
implements PushSender {
    private static final Log logger = LogFactory.getLog(PushSenderJPushImpl.class);
    private PushResponseReceiver receiver = new PushResponseReceiverImpl();
    private JPushOptions jPushOptions;
    private PushClient pushClient;

    public PushSenderJPushImpl(JPushOptions jPushOptions) {
        this.jPushOptions = jPushOptions;
        this.pushClient = new PushClient(jPushOptions.getAppSecret(), jPushOptions.getAppKey(), jPushOptions.getMaxRetries());
    }

    public void setPushResponseReceiver(PushResponseReceiver receiver) {
        if (receiver == null) {
            throw new NullPointerException();
        }
        this.receiver = receiver;
    }

    @Override
    @Listenable
    public void push(PushMessage message) {
        this.push(message, this.receiver);
    }

    @Override
    public void push(PushMessage message, PushResponseReceiver responseReceiver) {
        if (message.getPushType() == null) {
            throw new IllegalArgumentException("The push type is required.");
        }
        if (message.getPushWay() == null) {
            message.setPushWay(PushWay.Notification);
        }
        switch (message.getPushType()) {
            case All: {
                this.pushToAll(message, responseReceiver);
                return;
            }
            case Group: {
                this.pushToGroup(message, responseReceiver);
                return;
            }
            case TagOr: {
                this.pushToTagOr(message, responseReceiver);
            }
            case TagAnd: {
                this.pushToTagAnd(message, responseReceiver);
            }
            case Alias: {
                this.pushToAlias(message, responseReceiver);
            }
            case Device: {
                this.pushToDevice(message, responseReceiver);
            }
        }
    }

    private void pushToAll(PushMessage message, PushResponseReceiver responseReceiver) {
        PushPayload payload = this.createPayloadBuilder(message).setAudience(Audience.all()).build();
        this.doPush(message, payload, responseReceiver);
    }

    @Deprecated
    private void pushToGroup(PushMessage message, PushResponseReceiver responseReceiver) {
        PushPayload payload = this.createPayloadBuilder(message).setAudience(Audience.tag_and((String[])message.getGroups())).build();
        this.doPush(message, payload, responseReceiver);
    }

    private void pushToTagOr(PushMessage message, PushResponseReceiver responseReceiver) {
        PushPayload payload = this.createPayloadBuilder(message).setAudience(Audience.tag((String[])message.getTags())).build();
        this.doPush(message, payload, responseReceiver);
    }

    private void pushToTagAnd(PushMessage message, PushResponseReceiver responseReceiver) {
        PushPayload payload = this.createPayloadBuilder(message).setAudience(Audience.tag_and((String[])message.getTags())).build();
        this.doPush(message, payload, responseReceiver);
    }

    private void pushToAlias(PushMessage message, PushResponseReceiver responseReceiver) {
        PushPayload payload = this.createPayloadBuilder(message).setAudience(Audience.alias((String[])message.getAlias())).build();
        this.doPush(message, payload, responseReceiver);
    }

    @Deprecated
    private void pushToDevice(PushMessage message, PushResponseReceiver responseReceiver) {
        PushPayload payload = this.createPayloadBuilder(message).setAudience(Audience.alias((String[])message.getDevices())).build();
        this.doPush(message, payload, responseReceiver);
    }

    private PushPayload.Builder createPayloadBuilder(PushMessage message) {
        if (message.getPushWay() == PushWay.Notification) {
            IosNotification.Builder iosBuilder = IosNotification.newBuilder().setAlert(message.getTitle()).incrBadge(1);
            this.processAttributes(message, iosBuilder);
            IosNotification iosNotification = iosBuilder.addExtra("content", message.getContent()).build();
            AndroidNotification.Builder androidBuilder = AndroidNotification.newBuilder().setAlert(message.getTitle());
            this.processAttributes(message, androidBuilder);
            AndroidNotification androidNotification = androidBuilder.addExtra("content", message.getContent()).build();
            return PushPayload.newBuilder().setPlatform(Platform.all()).setNotification(Notification.newBuilder().addPlatformNotification((PlatformNotification)iosNotification).addPlatformNotification((PlatformNotification)androidNotification).build()).setOptions(Options.newBuilder().setTimeToLive(this.jPushOptions.getTimeToLive()).setApnsProduction(this.jPushOptions.isApnsProduction()).build());
        }
        if (message.getPushWay() == PushWay.Message) {
            Message.Builder msgBuilder = Message.newBuilder().setTitle(message.getTitle()).setMsgContent(message.getContent());
            this.processAttributes(message, msgBuilder);
            return PushPayload.newBuilder().setPlatform(Platform.all()).setMessage(msgBuilder.build()).setOptions(Options.newBuilder().setTimeToLive(this.jPushOptions.getTimeToLive()).setApnsProduction(this.jPushOptions.isApnsProduction()).build());
        }
        return null;
    }

    private void processAttributes(PushMessage message, Message.Builder iosBuilder) {
        for (Map.Entry<String, Object> entry : message.getAttributes().entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Number) {
                iosBuilder.addExtra(key, (Number)value);
                continue;
            }
            if (value instanceof Boolean) {
                iosBuilder.addExtra(key, (Boolean)value);
                continue;
            }
            if (value instanceof JsonObject) {
                iosBuilder.addExtra(key, ((JsonObject)value).toString());
                continue;
            }
            if (value instanceof String) {
                iosBuilder.addExtra(key, (String)value);
                continue;
            }
            iosBuilder.addExtra(key, value.toString());
        }
    }

    private void processAttributes(PushMessage message, IosNotification.Builder iosBuilder) {
        for (Map.Entry<String, Object> entry : message.getAttributes().entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Number) {
                iosBuilder.addExtra(key, (Number)value);
                continue;
            }
            if (value instanceof Boolean) {
                iosBuilder.addExtra(key, (Boolean)value);
                continue;
            }
            if (value instanceof JsonObject) {
                iosBuilder.addExtra(key, (JsonObject)value);
                continue;
            }
            if (value instanceof String) {
                iosBuilder.addExtra(key, (String)value);
                continue;
            }
            iosBuilder.addExtra(key, value.toString());
        }
    }

    private void processAttributes(PushMessage message, AndroidNotification.Builder buideer) {
        for (Map.Entry<String, Object> entry : message.getAttributes().entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Number) {
                buideer.addExtra(key, (Number)value);
                continue;
            }
            if (value instanceof Boolean) {
                buideer.addExtra(key, (Boolean)value);
                continue;
            }
            if (value instanceof JsonObject) {
                buideer.addExtra(key, (JsonObject)value);
                continue;
            }
            if (value instanceof String) {
                buideer.addExtra(key, (String)value);
                continue;
            }
            buideer.addExtra(key, value.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPush(PushMessage message, PushPayload payload, PushResponseReceiver responseReceiver) {
        if (payload == null) {
            return;
        }
        PushResponse response = new PushResponse();
        response.setRequest(message);
        try {
            PushResult result = this.pushClient.sendPush(payload);
            response.setSuccess(result.isResultOK());
        }
        catch (APIConnectionException e) {
            response.setSuccess(false);
            response.setNetworkFailed(true);
            response.setNetworkFailureReason(e.getMessage());
        }
        catch (APIRequestException e) {
            response.setSuccess(false);
            response.setErrorMessage(e.getErrorMessage());
            response.setErrorCode(Integer.toString(e.getErrorCode()));
        }
        finally {
            try {
                if (responseReceiver != null) {
                    responseReceiver.onResponse(response);
                }
            }
            catch (Throwable e) {}
        }
    }
}

