/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.es6.repository;

import java.lang.reflect.Array;
import org.elasticsearch.common.Strings;

public class Fields {
    private String[] includedFields = Strings.EMPTY_ARRAY;
    private String[] excludedFields = Strings.EMPTY_ARRAY;

    public static Fields empty() {
        return new Fields();
    }

    public String[] getIncludedFields() {
        return this.includedFields;
    }

    public String[] getExcludedFields() {
        return this.excludedFields;
    }

    public boolean isEmpty() {
        return !(this.includedFields != null && this.includedFields.length != 0 || this.excludedFields != null && this.excludedFields.length != 0);
    }

    public Fields includes(String ... fields) {
        if (fields == null) {
            return this;
        }
        this.includedFields = this.addAll(this.includedFields, fields);
        return this;
    }

    public Fields excludes(String ... fields) {
        if (fields == null) {
            return this;
        }
        this.excludedFields = this.addAll(this.excludedFields, fields);
        return this;
    }

    private <T> T[] clone(T[] array) {
        if (array == null) {
            return null;
        }
        return (Object[])array.clone();
    }

    private <T> T[] addAll(T[] array1, T ... array2) {
        if (array1 == null) {
            return this.clone(array2);
        }
        if (array2 == null) {
            return this.clone(array1);
        }
        Class<?> type1 = array1.getClass().getComponentType();
        Object[] joinedArray = (Object[])Array.newInstance(type1, array1.length + array2.length);
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        try {
            System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        }
        catch (ArrayStoreException ase) {
            Class<?> type2 = array2.getClass().getComponentType();
            if (!type1.isAssignableFrom(type2)) {
                throw new IllegalArgumentException("Cannot store " + type2.getName() + " in an array of " + type1.getName(), ase);
            }
            throw ase;
        }
        return joinedArray;
    }
}

