/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.es6.repository.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import in.clouthink.daas.es6.exception.Catching;
import in.clouthink.daas.es6.exception.DataNotFoundException;
import in.clouthink.daas.es6.exception.IncorrectResultSizeDataAccessException;
import in.clouthink.daas.es6.model.MutableIdentityProvider;
import in.clouthink.daas.es6.repository.EsCrudRepository;
import in.clouthink.daas.es6.repository.EsTemplate;
import in.clouthink.daas.es6.repository.Fields;
import in.clouthink.daas.es6.repository.SearchSourceBuilderBuilder;
import in.clouthink.daas.es6.repository.impl.XContentBuilderBuilder;
import in.clouthink.daas.es6.repository.metadata.IndexMetadata;
import in.clouthink.daas.es6.repository.metadata.IndexMetadataParser;
import in.clouthink.daas.es6.repository.page.PageableSearchRequest;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public abstract class SimpleEsCrudRepository<T extends MutableIdentityProvider<String>, R extends PageableSearchRequest>
extends EsTemplate
implements EsCrudRepository<T, R> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final RestHighLevelClient restHighLevelClient;
    private final ObjectMapper objectMapper;
    private RequestOptions requestOptions = RequestOptions.DEFAULT;
    private Class<T> entityClass;
    private IndexMetadata indexMetadata;

    public SimpleEsCrudRepository(RestHighLevelClient restHighLevelClient, ObjectMapper objectMapper) {
        this.restHighLevelClient = restHighLevelClient;
        this.objectMapper = objectMapper;
        this.entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.indexMetadata = IndexMetadataParser.parseIndexMetadata(this.entityClass);
    }

    @Override
    public RestHighLevelClient getRestHighLevelClient() {
        return this.restHighLevelClient;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    public RequestOptions getRequestOptions() {
        return this.requestOptions;
    }

    public void setRequestOptions(RequestOptions requestOptions) {
        this.requestOptions = requestOptions;
    }

    protected String getEsIndex() {
        return this.indexMetadata.getIndexName();
    }

    protected Class<T> getJavaType() {
        return this.entityClass;
    }

    public void createIndex() {
        this.createIndex(this.getEsIndex());
    }

    public void createType() {
        this.createType(this.getEsIndex(), "_doc", XContentBuilderBuilder.buildFrom(this.getJavaType()));
    }

    @Override
    public String save(T data) {
        return Catching.around(() -> this.doSave(data));
    }

    protected String doSave(T data) throws Exception {
        if (this.indexMetadata.isGenerateUuid()) {
            data.setId((String)UUID.randomUUID().toString().replaceAll("-", ""));
        }
        Map dataMap = (Map)this.getObjectMapper().convertValue(data, Map.class);
        IndexRequest indexRequest = new IndexRequest(this.getEsIndex(), "_doc", (String)data.getId()).source(dataMap);
        IndexResponse indexResponse = this.getRestHighLevelClient().index(indexRequest, this.getRequestOptions());
        this.logger.debug((Object)String.format("save %s result : %s", this.getObjectMapper().writeValueAsString(data), indexResponse.getResult()));
        data.setId((String)indexResponse.getId());
        return (String)data.getId();
    }

    @Override
    public void saveBulk(T ... records) {
        Catching.around(() -> this.doSaveBulk((MutableIdentityProvider[])records));
    }

    protected void doSaveBulk(T ... records) throws Exception {
        BulkRequest bulkRequest = new BulkRequest();
        for (String item : records) {
            if (this.indexMetadata.isGenerateUuid()) {
                item.setId((String)UUID.randomUUID().toString().replaceAll("-", ""));
            }
            Map dataMap = (Map)this.getObjectMapper().convertValue(item, Map.class);
            IndexRequest indexRequest = new IndexRequest(this.getEsIndex(), (String)item.getId()).source(dataMap);
            bulkRequest.add(indexRequest);
        }
        this.getRestHighLevelClient().bulk(bulkRequest, this.getRequestOptions());
    }

    @Override
    public void update(String id, T data) {
        Catching.around(() -> this.doUpdate(id, data));
    }

    protected void doUpdate(String id, T data) throws Exception {
        T exists = this.getOne(id);
        if (exists == null) {
            throw new DataNotFoundException(String.format("The data[id=%s] not found.", id));
        }
        UpdateRequest updateRequest = new UpdateRequest(this.getEsIndex(), "_doc", id).fetchSource(true);
        String dataJson = this.getObjectMapper().writeValueAsString(data);
        updateRequest.doc(dataJson, XContentType.JSON);
        UpdateResponse updateResponse = this.getRestHighLevelClient().update(updateRequest, this.getRequestOptions());
        this.logger.debug((Object)String.format("update %s result : %s", dataJson, updateResponse.getResult()));
    }

    @Override
    public void delete(String id) {
        Catching.around(() -> this.doDelete(id));
    }

    public void doDelete(String id) throws Exception {
        T exists = this.getOne(id);
        if (exists == null) {
            return;
        }
        DeleteRequest deleteRequest = new DeleteRequest(this.getEsIndex(), "_doc", id);
        DeleteResponse deleteResponse = this.getRestHighLevelClient().delete(deleteRequest, this.getRequestOptions());
        this.logger.debug((Object)String.format("delete %s result : %s", id, deleteResponse.getResult()));
    }

    @Override
    public T getOne(String id) {
        return (T)Catching.around(() -> this.doGetOne(id));
    }

    protected T doGetOne(String id) throws Exception {
        GetRequest getRequest = new GetRequest(this.getEsIndex(), "_doc", id);
        GetResponse getResponse = this.getRestHighLevelClient().get(getRequest, this.getRequestOptions());
        if (!getResponse.isExists()) {
            return null;
        }
        Map resultMap = getResponse.getSource();
        MutableIdentityProvider result = (MutableIdentityProvider)this.getObjectMapper().convertValue((Object)resultMap, this.getJavaType());
        result.setId(getResponse.getId());
        return (T)result;
    }

    @Override
    public Page<T> search(R searchRequest) {
        return Catching.around(() -> this.doSearch(searchRequest, Fields.empty()));
    }

    @Override
    public Page<T> search(R searchRequest, Fields fields) {
        return Catching.around(() -> this.doSearch(searchRequest, fields));
    }

    protected Page<T> doSearch(R request, Fields fields) throws Exception {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.getEsIndex()});
        SearchSourceBuilder searchSourceBuilder = this.buildSearchSource(request, fields);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.getRestHighLevelClient().search(searchRequest, this.getRequestOptions());
        SearchHits searchResponseHits = searchResponse.getHits();
        List<T> searchResultList = this.convertEsResult(searchResponseHits);
        return new PageImpl(searchResultList, request.resolvePageable(), searchResponseHits.totalHits);
    }

    @Override
    public Page<T> getAll(PageableSearchRequest pageableSearchRequest) {
        return Catching.around(() -> this.doGetAll(pageableSearchRequest, Fields.empty()));
    }

    @Override
    public Page<T> getAll(PageableSearchRequest pageableSearchRequest, Fields fields) {
        return Catching.around(() -> this.doGetAll(pageableSearchRequest, fields));
    }

    protected Page<T> doGetAll(PageableSearchRequest request, Fields fields) throws Exception {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.getEsIndex()});
        Pageable pageable = request.resolvePageable();
        SearchSourceBuilder searchSourceBuilder = SearchSourceBuilderBuilder.build(request.resolvePageable(), fields);
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.getRestHighLevelClient().search(searchRequest, this.getRequestOptions());
        SearchHits searchResponseHits = searchResponse.getHits();
        List<T> searchResultList = this.convertEsResult(searchResponseHits);
        return new PageImpl(searchResultList, pageable, searchResponseHits.totalHits);
    }

    public T getFirst(SearchSourceBuilder searchSourceBuilder) {
        return (T)Catching.around(() -> this.doGetFirst(searchSourceBuilder));
    }

    protected T doGetFirst(SearchSourceBuilder searchSourceBuilder) throws Exception {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.getEsIndex()});
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.getRestHighLevelClient().search(searchRequest, this.getRequestOptions());
        SearchHits searchResponseHits = searchResponse.getHits();
        if (searchResponseHits.getTotalHits() == 0L) {
            return null;
        }
        SearchHit searchHit = searchResponseHits.getAt(0);
        MutableIdentityProvider result = (MutableIdentityProvider)this.getObjectMapper().convertValue((Object)searchHit.getSourceAsMap(), this.getJavaType());
        result.setId(searchHit.getId());
        return (T)result;
    }

    public T getOne(SearchSourceBuilder searchSourceBuilder) {
        return (T)Catching.around(() -> this.doGetOne(searchSourceBuilder));
    }

    protected T doGetOne(SearchSourceBuilder searchSourceBuilder) throws Exception {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.getEsIndex()});
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.getRestHighLevelClient().search(searchRequest, this.getRequestOptions());
        SearchHits searchResponseHits = searchResponse.getHits();
        if (searchResponseHits.getTotalHits() == 0L) {
            return null;
        }
        if (searchResponseHits.getTotalHits() > 1L) {
            throw new IncorrectResultSizeDataAccessException(1, searchResponseHits.getTotalHits());
        }
        SearchHit searchHit = searchResponseHits.getAt(0);
        MutableIdentityProvider result = (MutableIdentityProvider)this.getObjectMapper().convertValue((Object)searchHit.getSourceAsMap(), this.getJavaType());
        result.setId(searchHit.getId());
        return (T)result;
    }

    protected List<T> convertEsResult(SearchHits searchHits) {
        ArrayList searchResultList = new ArrayList();
        SearchHit[] hits = searchHits.getHits();
        if (hits.length > 0) {
            Arrays.stream(hits).forEach(item -> {
                MutableIdentityProvider resultItem = (MutableIdentityProvider)this.getObjectMapper().convertValue((Object)item.getSourceAsMap(), this.getJavaType());
                resultItem.setId(item.getId());
                searchResultList.add(resultItem);
            });
        }
        return searchResultList;
    }

    protected SearchSourceBuilder buildSearchSource(R request, Fields fields) {
        return SearchSourceBuilderBuilder.build(request.resolvePageable(), fields);
    }
}

