/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.es6.exception;

import in.clouthink.daas.es6.exception.DataAccessException;

public class IncorrectResultSizeDataAccessException
extends DataAccessException {
    private int expectedSize;
    private long actualSize;

    public IncorrectResultSizeDataAccessException(int expectedSize) {
        super("Incorrect result size: expected " + expectedSize);
        this.expectedSize = expectedSize;
        this.actualSize = -1L;
    }

    public IncorrectResultSizeDataAccessException(int expectedSize, long actualSize) {
        super("Incorrect result size: expected " + expectedSize + ", actual " + actualSize);
        this.expectedSize = expectedSize;
        this.actualSize = actualSize;
    }

    public IncorrectResultSizeDataAccessException(String msg, int expectedSize) {
        super(msg);
        this.expectedSize = expectedSize;
        this.actualSize = -1L;
    }

    public IncorrectResultSizeDataAccessException(String msg, int expectedSize, Throwable ex) {
        super(msg, ex);
        this.expectedSize = expectedSize;
        this.actualSize = -1L;
    }

    public IncorrectResultSizeDataAccessException(String msg, int expectedSize, long actualSize) {
        super(msg);
        this.expectedSize = expectedSize;
        this.actualSize = actualSize;
    }

    public IncorrectResultSizeDataAccessException(String msg, int expectedSize, long actualSize, Throwable ex) {
        super(msg, ex);
        this.expectedSize = expectedSize;
        this.actualSize = actualSize;
    }

    public int getExpectedSize() {
        return this.expectedSize;
    }

    public long getActualSize() {
        return this.actualSize;
    }
}

