/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.es6.repository;

import in.clouthink.daas.es6.exception.Catching;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.GetMappingsResponse;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.xcontent.XContentBuilder;

public abstract class EsTemplate {
    private static final Log log = LogFactory.getLog(EsTemplate.class);
    public static final String ES_DEFAULT_TYPE = "_doc";

    public abstract RestHighLevelClient getRestHighLevelClient();

    public abstract RequestOptions getRequestOptions();

    public GetIndexResponse getIndex(String indexName) {
        return Catching.around(() -> this.doGetIndex(indexName));
    }

    protected GetIndexResponse doGetIndex(String indexName) throws Exception {
        return this.getRestHighLevelClient().indices().get(new GetIndexRequest(new String[]{indexName}), this.getRequestOptions());
    }

    public boolean indexExists(String indexName) {
        boolean result = Catching.around(() -> this.doIndexExists(indexName));
        log.debug((Object)String.format("index:%s  existed:%s", indexName, result));
        return result;
    }

    protected boolean doIndexExists(String indexName) throws Exception {
        return this.getRestHighLevelClient().indices().exists(new GetIndexRequest(new String[]{indexName}), this.getRequestOptions());
    }

    public void createIndex(String indexName) {
        Catching.around(() -> this.doCreateIndex(indexName));
    }

    protected void doCreateIndex(String indexName) throws Exception {
        if (!this.indexExists(indexName)) {
            this.getRestHighLevelClient().indices().create(new CreateIndexRequest(indexName), this.getRequestOptions());
            log.debug((Object)String.format("index:%s is created", indexName));
        }
    }

    public MappingMetaData typeMappings(String indexName, String typeName) {
        return Catching.around(() -> this.doTypeMappings(indexName, typeName));
    }

    protected MappingMetaData doTypeMappings(String indexName, String typeName) throws Exception {
        GetMappingsRequest getMappingsRequest = new GetMappingsRequest();
        getMappingsRequest.indices(new String[]{indexName});
        GetMappingsResponse getMappingResponse = this.getRestHighLevelClient().indices().getMapping(getMappingsRequest, this.getRequestOptions());
        return (MappingMetaData)getMappingResponse.mappings().get(typeName);
    }

    public boolean typeExists(String indexName, String typeName) {
        boolean result = Catching.around(() -> this.doTypeExists(indexName, typeName));
        log.debug((Object)String.format("index:%s  type:%s  existed:%s", indexName, typeName, result));
        return result;
    }

    protected boolean doTypeExists(String indexName, String typeName) throws Exception {
        GetMappingsRequest getMappingsRequest = new GetMappingsRequest();
        getMappingsRequest.indices(new String[]{indexName});
        GetMappingsResponse getMappingResponse = this.getRestHighLevelClient().indices().getMapping(getMappingsRequest, this.getRequestOptions());
        MappingMetaData mappingMetaData = (MappingMetaData)getMappingResponse.mappings().get(indexName);
        if (mappingMetaData == null) {
            return false;
        }
        return mappingMetaData.type().equals(typeName) && !mappingMetaData.sourceAsMap().isEmpty();
    }

    public void createType(String indexName, String typeName, XContentBuilder contentBuilder) {
        Catching.around(() -> this.doCreateType(indexName, typeName, contentBuilder));
    }

    protected void doCreateType(String indexName, String typeName, XContentBuilder contentBuilder) throws Exception {
        if (!this.typeExists(indexName, typeName)) {
            PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{indexName});
            putMappingRequest.source(contentBuilder);
            AcknowledgedResponse acknowledgedResponse = this.getRestHighLevelClient().indices().putMapping(putMappingRequest, this.getRequestOptions());
            log.debug((Object)String.format("index:%s  type:%s  created:%s", indexName, typeName, acknowledgedResponse.isAcknowledged()));
        }
    }
}

