/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.es6.repository;

import in.clouthink.daas.es6.repository.Fields;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class SearchSourceBuilderBuilder {
    public static SearchSourceBuilder build(Pageable pageable) {
        return SearchSourceBuilderBuilder.build(pageable, Fields.empty());
    }

    public static SearchSourceBuilder build(Pageable pageable, Fields fields) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.from(pageable.getOffset());
        searchSourceBuilder.size(pageable.getPageSize());
        if (pageable.getSort() != null) {
            for (Sort.Order sortOrder : pageable.getSort()) {
                searchSourceBuilder.sort(sortOrder.getProperty(), sortOrder.getDirection() == Sort.Direction.ASC ? SortOrder.ASC : SortOrder.DESC);
            }
        }
        if (fields != null && !fields.isEmpty()) {
            searchSourceBuilder.fetchSource(fields.getIncludedFields(), fields.getExcludedFields());
        }
        return searchSourceBuilder;
    }
}

