/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.fss.alioss.impl;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import in.clouthink.daas.fss.alioss.exception.AliossStoreException;
import in.clouthink.daas.fss.alioss.impl.DefaultStoredFileObject;
import in.clouthink.daas.fss.alioss.impl.OssObjectProxy;
import in.clouthink.daas.fss.alioss.support.OssProperties;
import in.clouthink.daas.fss.core.FileStorage;
import in.clouthink.daas.fss.core.StoreFileException;
import in.clouthink.daas.fss.core.StoreFileRequest;
import in.clouthink.daas.fss.core.StoreFileResponse;
import in.clouthink.daas.fss.core.StoredFileObject;
import in.clouthink.daas.fss.support.DefaultStoreFileResponse;
import in.clouthink.daas.fss.util.IOUtils;
import in.clouthink.daas.fss.util.MetadataUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FileStorageImpl
implements FileStorage,
InitializingBean,
DisposableBean {
    private static final Log logger = LogFactory.getLog(FileStorageImpl.class);
    public static final String PROVIDER_NAME = "alioss";
    @Autowired
    private OssProperties ossProperties;
    private OSSClient ossClient;

    public String getName() {
        return PROVIDER_NAME;
    }

    public boolean isMetadataSupported() {
        return true;
    }

    public StoreFileResponse store(InputStream inputStream, StoreFileRequest request) throws StoreFileException {
        String ossBucket = this.resolveBucket(request);
        String ossObjectName = MetadataUtils.generateFilename((StoreFileRequest)request, (boolean)true);
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentType(request.getContentType());
        objectMetadata.setUserMetadata(MetadataUtils.buildMetadata((StoreFileRequest)request));
        PutObjectResult putObjectResult = this.ossClient.putObject(ossBucket, ossObjectName, inputStream, objectMetadata);
        if (putObjectResult == null) {
            throw new StoreFileException(String.format("Fail to upload %s", request.getOriginalFilename()));
        }
        if (putObjectResult.getResponse() != null) {
            if (putObjectResult.getResponse().getStatusCode() != 200) {
                throw new StoreFileException(String.format("Fail to upload %s", request.getOriginalFilename()));
            }
            try {
                logger.debug((Object)String.format("Response for uploading %s : %s", request.getOriginalFilename(), IOUtils.readAsString((InputStream)putObjectResult.getResponse().getContent())));
            }
            catch (Throwable e) {
                logger.error((Object)"Fail to parse uploading response content", e);
                IOUtils.close((Closeable)putObjectResult.getResponse().getContent());
            }
        }
        logger.debug((Object)String.format("The uploading %s stored as oss-object[bucket=%s,object=%s]", request.getOriginalFilename(), ossBucket, ossObjectName));
        DefaultStoredFileObject fileObject = DefaultStoredFileObject.from(request);
        String url = "https://" + ossBucket + "." + this.ossProperties.getEndpoint() + "/" + ossObjectName;
        fileObject.getAttributes().put("oss-bucket", ossBucket);
        fileObject.getAttributes().put("oss-object", ossObjectName);
        fileObject.getAttributes().put("oss-url", url);
        String uploadedAt = (String)objectMetadata.getUserMetadata().get("fss-uploadedAt");
        fileObject.setUploadedAt(uploadedAt != null ? new Date(Long.parseLong(uploadedAt)) : null);
        fileObject.setFileUrl(url);
        fileObject.setStoredFilename(ossBucket + ":" + ossObjectName);
        fileObject.setProviderName(PROVIDER_NAME);
        fileObject.setImplementation(new OssObjectProxy(this.ossClient, ossBucket, ossObjectName));
        return new DefaultStoreFileResponse(PROVIDER_NAME, (StoredFileObject)fileObject);
    }

    public StoreFileResponse store(File file, StoreFileRequest request) throws StoreFileException {
        try {
            return this.store(new FileInputStream(file), request);
        }
        catch (FileNotFoundException e) {
            throw new AliossStoreException(file.getName() + " not found.", e);
        }
    }

    public StoreFileResponse store(byte[] bytes, StoreFileRequest request) throws StoreFileException {
        return this.store(new ByteArrayInputStream(bytes), request);
    }

    public StoredFileObject findByStoredFilename(String filename) {
        String ossObjectKey;
        if (StringUtils.isEmpty((Object)filename)) {
            return null;
        }
        if (filename.indexOf("?") > 0) {
            filename = filename.substring(0, filename.indexOf("?"));
        }
        if (filename.indexOf(":") <= 0) {
            throw new AliossStoreException(String.format("Invalid filename %s , the format should be bucket_name:object_name", filename));
        }
        String ossBucket = filename.split(":")[0];
        OSSObject ossObject = this.ossClient.getObject(ossBucket, ossObjectKey = filename.split(":")[1]);
        if (ossObject == null) {
            return null;
        }
        DefaultStoredFileObject fileObject = new DefaultStoredFileObject();
        this.buildStoreFileObject(ossObject, fileObject);
        String fileUrl = (String)ossObject.getObjectMetadata().getUserMetadata().get("oss-url");
        fileObject.setFileUrl(fileUrl);
        fileObject.setStoredFilename(filename);
        fileObject.setProviderName(PROVIDER_NAME);
        fileObject.setImplementation(new OssObjectProxy(ossObject));
        return fileObject;
    }

    public StoredFileObject findByStoredFilename(String filename, String downloadUrl) {
        logger.warn((Object)String.format("Caution: The download url[%s] will be skipped", downloadUrl));
        return this.findByStoredFilename(filename);
    }

    public StoredFileObject delete(String filename) {
        String ossObjectKey;
        if (StringUtils.isEmpty((Object)filename)) {
            return null;
        }
        if (filename.indexOf("?") > 0) {
            filename = filename.substring(0, filename.indexOf("?"));
        }
        if (filename.indexOf(":") <= 0) {
            throw new AliossStoreException(String.format("Invalid filename %s , the format should be bucket_name:object_name", filename));
        }
        String ossBucket = filename.split(":")[0];
        OSSObject ossObject = this.ossClient.getObject(ossBucket, ossObjectKey = filename.split(":")[1]);
        if (ossObject == null) {
            return null;
        }
        DefaultStoredFileObject fileObject = new DefaultStoredFileObject();
        this.buildStoreFileObject(ossObject, fileObject);
        fileObject.setStoredFilename(filename);
        fileObject.setProviderName(PROVIDER_NAME);
        fileObject.setImplementation(null);
        try {
            this.ossClient.deleteObject(ossBucket, ossObjectKey);
            logger.debug((Object)String.format("The oss-object[bucket=%s,object=%s] is deleted.", ossBucket, ossObjectKey));
        }
        catch (Throwable e) {
            logger.error((Object)String.format("Fail to delete the oss-object[bucket=%s,object=%s]", ossBucket, ossObjectKey), e);
        }
        return fileObject;
    }

    private void buildStoreFileObject(OSSObject ossObject, DefaultStoredFileObject fileObject) {
        Map userMetadata = ossObject.getObjectMetadata().getUserMetadata();
        if (userMetadata == null) {
            return;
        }
        try {
            fileObject.setOriginalFilename((String)userMetadata.get("fss-originalfilename"));
            fileObject.setPrettyFilename((String)userMetadata.get("fss-prettyfilename"));
            fileObject.setContentType((String)userMetadata.get("fss-contenttype"));
            fileObject.setUploadedBy((String)userMetadata.get("fss-uploadedby"));
            String uploadedAt = (String)userMetadata.get("fss-uploadedat");
            fileObject.setUploadedAt(uploadedAt != null ? new Date(Long.parseLong(uploadedAt)) : null);
            String size = (String)userMetadata.get("fss-size");
            fileObject.setSize(size != null ? Long.parseLong(size) : -1L);
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
        }
        try {
            HashMap attributes = new HashMap();
            userMetadata.keySet().stream().filter(key -> key.startsWith("fss-attrs-")).forEach(key -> {
                String attributeName = key.substring("fss-attrs-".length());
                attributes.put(attributeName, userMetadata.get(key));
            });
            fileObject.setAttributes(attributes);
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
        }
    }

    private String resolveBucket(StoreFileRequest request) {
        String category = (String)request.getAttributes().get("category");
        String bucket = this.ossProperties.getBuckets().get(category);
        if (StringUtils.isEmpty((Object)bucket)) {
            bucket = this.ossProperties.getDefaultBucket();
        }
        return bucket;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.ossProperties);
        this.ossClient = new OSSClient("http://" + this.ossProperties.getEndpoint(), this.ossProperties.getKeyId(), this.ossProperties.getKeySecret());
        if (this.ossProperties.getClientConfiguration() != null) {
            BeanUtils.copyProperties((Object)this.ossProperties.getClientConfiguration(), (Object)this.ossClient.getClientConfiguration());
        }
    }

    public void destroy() {
        if (this.ossClient != null) {
            this.ossClient.shutdown();
        }
    }
}

