/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.fss.fastdfs.impl;

import in.clouthink.daas.fss.core.FileStorage;
import in.clouthink.daas.fss.core.StoreFileException;
import in.clouthink.daas.fss.core.StoreFileRequest;
import in.clouthink.daas.fss.core.StoreFileResponse;
import in.clouthink.daas.fss.core.StoredFileObject;
import in.clouthink.daas.fss.fastdfs.exception.FastdfsStoreException;
import in.clouthink.daas.fss.fastdfs.impl.DefaultStoredFileObject;
import in.clouthink.daas.fss.fastdfs.impl.FastFile;
import in.clouthink.daas.fss.fastdfs.support.FastdfsProperties;
import in.clouthink.daas.fss.repackage.org.apache.commons.io.FilenameUtils;
import in.clouthink.daas.fss.support.DefaultStoreFileResponse;
import in.clouthink.daas.fss.util.IOUtils;
import in.clouthink.daas.fss.util.MetadataUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.csource.common.NameValuePair;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.FileInfo;
import org.csource.fastdfs.StorageClient;
import org.csource.fastdfs.StorageServer;
import org.csource.fastdfs.TrackerClient;
import org.csource.fastdfs.TrackerGroup;
import org.csource.fastdfs.TrackerServer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FileStorageImpl
implements FileStorage,
InitializingBean,
DisposableBean {
    private static final Log logger = LogFactory.getLog(FileStorageImpl.class);
    public static final String PROVIDER_NAME = "fastdfs";
    @Autowired
    private FastdfsProperties fastdfsProperties;
    private TrackerClient trackerClient;
    private TrackerServer trackerServer;
    private StorageServer storageServer;

    public FastdfsProperties getFastdfsProperties() {
        return this.fastdfsProperties;
    }

    public String getName() {
        return PROVIDER_NAME;
    }

    public boolean isMetadataSupported() {
        return false;
    }

    public StoreFileResponse store(InputStream inputStream, StoreFileRequest request) throws StoreFileException {
        String originalFilename = request.getOriginalFilename();
        String fileExtName = FilenameUtils.getExtension((String)originalFilename);
        Map metadata = MetadataUtils.buildMetadata((StoreFileRequest)request, (boolean)true);
        NameValuePair[] metadataOfNameValuePair = metadata.entrySet().stream().map(entry -> new NameValuePair((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList()).toArray(new NameValuePair[0]);
        try {
            StorageClient storageClient = new StorageClient(this.trackerServer, this.storageServer);
            String[] result = storageClient.uploadFile(IOUtils.copyToByteArray((InputStream)inputStream), fileExtName, metadataOfNameValuePair);
            if (result == null || result.length != 2) {
                throw new FastdfsStoreException(String.format("Fail to upload file %s , unknown reason.", originalFilename));
            }
            String group_name = result[0];
            String remote_filename = result[1];
            logger.debug((Object)String.format("The uploading %s is stored to [group=%s , filename=%s]", originalFilename, group_name, remote_filename));
            DefaultStoredFileObject fileObject = DefaultStoredFileObject.from(request);
            fileObject.setStoredFilename(group_name + ":" + remote_filename);
            fileObject.setFileUrl(remote_filename);
            fileObject.setUploadedAt(new Date());
            fileObject.setProviderName(PROVIDER_NAME);
            try {
                FileInfo fileInfo = storageClient.getFileInfo(group_name, remote_filename);
                long fileSize = fileInfo.getFileSize();
                fileObject.setSize(fileSize);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            fileObject.setImplementation(new FastFile(group_name, remote_filename, storageClient));
            return new DefaultStoreFileResponse(PROVIDER_NAME, (StoredFileObject)fileObject);
        }
        catch (FastdfsStoreException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new FastdfsStoreException(String.format("Fail to upload file %s", originalFilename), e);
        }
    }

    public StoreFileResponse store(File file, StoreFileRequest request) throws StoreFileException {
        try {
            return this.store(new FileInputStream(file), request);
        }
        catch (FileNotFoundException e) {
            throw new FastdfsStoreException(String.format("%s not existed.", file.getName()), e);
        }
    }

    public StoreFileResponse store(byte[] bytes, StoreFileRequest request) throws StoreFileException {
        return this.store(new ByteArrayInputStream(bytes), request);
    }

    public StoredFileObject findByStoredFilename(String filename) {
        if (StringUtils.isEmpty((Object)filename)) {
            return null;
        }
        if (filename.indexOf("?") > 0) {
            filename = filename.substring(0, filename.indexOf("?"));
        }
        if (filename.indexOf(":") <= 0) {
            throw new FastdfsStoreException(String.format("Invalid filename %s , the format should be group_name:file_path", filename));
        }
        String group_name = filename.split(":")[0];
        String remote_filename = filename.split(":")[1];
        try {
            StorageClient storageClient = new StorageClient(this.trackerServer, this.storageServer);
            FileInfo fileInfo = storageClient.getFileInfo(group_name, remote_filename);
            NameValuePair[] metadata = storageClient.getMetadata(group_name, remote_filename);
            if (fileInfo == null) {
                logger.warn((Object)String.format("File [%s] not found.", filename));
                return null;
            }
            DefaultStoredFileObject fileObject = new DefaultStoredFileObject();
            this.buildStoreFileObject(metadata, fileObject);
            fileObject.setStoredFilename(filename);
            fileObject.setFileUrl(remote_filename);
            fileObject.setProviderName(PROVIDER_NAME);
            fileObject.setImplementation(new FastFile(group_name, remote_filename, storageClient));
            return fileObject;
        }
        catch (Throwable e) {
            logger.error((Object)String.format("Fail to get the file [%s]", filename), e);
            return null;
        }
    }

    public StoredFileObject findByStoredFilename(String filename, String downloadUrl) {
        logger.warn((Object)String.format("Caution: The download url[%s] will be skipped", downloadUrl));
        return this.findByStoredFilename(filename);
    }

    public StoredFileObject delete(String filename) {
        if (StringUtils.isEmpty((Object)filename)) {
            return null;
        }
        if (filename.indexOf("?") > 0) {
            filename = filename.substring(0, filename.indexOf("?"));
        }
        if (filename.indexOf(":") <= 0) {
            throw new FastdfsStoreException(String.format("Invalid filename %s , the format should be group_name:file_path", filename));
        }
        String group_name = filename.split(":")[0];
        String remote_filename = filename.split(":")[1];
        try {
            StorageClient storageClient = new StorageClient(this.trackerServer, this.storageServer);
            FileInfo fileInfo = storageClient.getFileInfo(group_name, remote_filename);
            NameValuePair[] metadata = storageClient.getMetadata(group_name, remote_filename);
            if (fileInfo == null) {
                logger.warn((Object)String.format("File [%s] not found.", filename));
                return null;
            }
            DefaultStoredFileObject fileObject = new DefaultStoredFileObject();
            this.buildStoreFileObject(metadata, fileObject);
            fileObject.setStoredFilename(filename);
            fileObject.setFileUrl(remote_filename);
            fileObject.setProviderName(PROVIDER_NAME);
            fileObject.setImplementation(null);
            storageClient.deleteFile(group_name, remote_filename);
            logger.info((Object)String.format("The file[group=%s , filename=%s] is deleted.", group_name, remote_filename));
            return fileObject;
        }
        catch (Throwable e) {
            logger.error((Object)String.format("Fail to delete the file [%s]", filename), e);
            return null;
        }
    }

    private void buildStoreFileObject(NameValuePair[] metadata, DefaultStoredFileObject fileObject) {
        if (metadata == null || metadata.length == 0) {
            return;
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (NameValuePair item : metadata) {
            try {
                if ("fss-originalFilename".equals(item.getName())) {
                    fileObject.setOriginalFilename(item.getValue());
                    continue;
                }
                if ("fss-prettyFilename".equals(item.getName())) {
                    fileObject.setPrettyFilename(item.getValue());
                    continue;
                }
                if ("fss-contentType".equals(item.getName())) {
                    fileObject.setContentType(item.getValue());
                    continue;
                }
                if ("fss-uploadedBy".equals(item.getName())) {
                    fileObject.setUploadedBy(item.getValue());
                    continue;
                }
                if ("fss-uploadedAt".equals(item.getName())) {
                    fileObject.setUploadedAt(item.getValue() != null ? new Date(Long.parseLong(item.getValue())) : null);
                    continue;
                }
                if ("fss-size".equals(item.getName())) {
                    fileObject.setSize(item.getValue() != null ? Long.parseLong(item.getValue()) : -1L);
                    continue;
                }
                if (!item.getName().startsWith("fss-attrs-")) continue;
                String attributeName = item.getName().substring("fss-attrs-".length());
                attributes.put(attributeName, item.getValue());
            }
            catch (Throwable e) {
                logger.error((Object)e, e);
            }
        }
        fileObject.setAttributes(attributes);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.fastdfsProperties);
        try {
            ClientGlobal.setAntiStealToken((boolean)this.fastdfsProperties.isHttpAntiStealToken());
            ClientGlobal.setCharset((String)this.fastdfsProperties.getCharset());
            ClientGlobal.setConnectTimeout((int)this.fastdfsProperties.getConnectTimeoutInseconds());
            ClientGlobal.setNetworkTimeout((int)this.fastdfsProperties.getNetworkTimeoutInSeconds());
            ClientGlobal.setSecretKey((String)this.fastdfsProperties.getHttpSecretKey());
            TrackerGroup trackerGroup = new TrackerGroup(this.fastdfsProperties.getTrackerServers().stream().map(server -> {
                try {
                    return new InetSocketAddress(server.split(":")[0], Integer.parseInt(server.split(":")[1]));
                }
                catch (Throwable e) {
                    logger.error((Object)("Unresolvable tracker server " + server), e);
                    return null;
                }
            }).filter(address -> address != null).collect(Collectors.toList()).toArray(new InetSocketAddress[0]));
            ClientGlobal.setTrackerGroup((TrackerGroup)trackerGroup);
            ClientGlobal.setTrackerHttpPort((int)this.fastdfsProperties.getHttpTrackerHttpPort());
            this.trackerClient = new TrackerClient();
            this.trackerServer = this.trackerClient.getConnection();
            Assert.notNull((Object)this.trackerServer);
            this.storageServer = this.trackerClient.getStoreStorage(this.trackerServer);
            Assert.notNull((Object)this.storageServer);
        }
        catch (Throwable e) {
            throw new FastdfsStoreException("Fail to initialize FastDFS client.", e);
        }
    }

    public void destroy() {
        try {
            this.trackerServer.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.storageServer.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

