/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.fss.fastdfs.impl;

import in.clouthink.daas.fss.fastdfs.exception.FastdfsDownloadException;
import in.clouthink.daas.fss.util.IOUtils;
import java.io.IOException;
import java.io.OutputStream;
import org.csource.common.FastdfsException;
import org.csource.fastdfs.StorageClient;

public class FastFile {
    private String group;
    private String filename;
    private StorageClient storageClient;

    public FastFile(String group, String filename, StorageClient storageClient) {
        this.group = group;
        this.filename = filename;
        this.storageClient = storageClient;
    }

    public String getGroup() {
        return this.group;
    }

    public String getFilename() {
        return this.filename;
    }

    public StorageClient getStorageClient() {
        return this.storageClient;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            byte[] dataInBytes = this.storageClient.downloadFile(this.group, this.filename);
            IOUtils.copy((byte[])dataInBytes, (OutputStream)outputStream);
        }
        catch (FastdfsException e) {
            throw new FastdfsDownloadException("Fail to write to output stream", e);
        }
    }
}

