/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.fss.gridfs.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import in.clouthink.daas.fss.core.FileStorage;
import in.clouthink.daas.fss.core.StoreFileException;
import in.clouthink.daas.fss.core.StoreFileRequest;
import in.clouthink.daas.fss.core.StoreFileResponse;
import in.clouthink.daas.fss.core.StoredFileObject;
import in.clouthink.daas.fss.gridfs.impl.DefaultStoredFileObject;
import in.clouthink.daas.fss.repackage.org.apache.commons.io.FilenameUtils;
import in.clouthink.daas.fss.support.DefaultStoreFileResponse;
import in.clouthink.daas.fss.util.MetadataUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.util.StringUtils;

public class FileStorageImpl
implements FileStorage,
InitializingBean {
    private static final Log logger = LogFactory.getLog(FileStorageImpl.class);
    public static final String PROVIDER_NAME = "gridfs";
    public static final String GRIDFS_COLLECTION_NAME = "FileObjects";
    @Autowired
    private MongoDbFactory mongoDbFactory;
    private GridFS gridFS;
    private String collectionName = "FileObjects";

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        if (StringUtils.isEmpty((Object)collectionName)) {
            throw new IllegalArgumentException("The collection name can't be null or empty");
        }
        this.collectionName = collectionName;
    }

    public GridFS getGridFS() {
        return this.gridFS;
    }

    public String getName() {
        return PROVIDER_NAME;
    }

    public boolean isMetadataSupported() {
        return true;
    }

    public StoreFileResponse store(InputStream inputStream, StoreFileRequest request) throws StoreFileException {
        String filenameToStore = UUID.randomUUID().toString().replace("-", "");
        String extName = FilenameUtils.getExtension((String)request.getOriginalFilename());
        if (!StringUtils.isEmpty((Object)extName)) {
            filenameToStore = filenameToStore + "." + extName;
        }
        GridFSInputFile gfsInputFile = this.gridFS.createFile(inputStream);
        gfsInputFile.setFilename(filenameToStore);
        gfsInputFile.setContentType(request.getContentType());
        Map metadata = MetadataUtils.buildMetadata((StoreFileRequest)request);
        BasicDBObject dbObject = new BasicDBObject(metadata);
        gfsInputFile.setMetaData((DBObject)dbObject);
        gfsInputFile.save();
        logger.debug((Object)String.format("%s is stored", filenameToStore));
        GridFSDBFile gridFSDBFile = this.gridFS.findOne(filenameToStore);
        DefaultStoredFileObject fileObject = DefaultStoredFileObject.from(request);
        fileObject.setSize(gridFSDBFile.getChunkSize());
        fileObject.setUploadedAt(gridFSDBFile.getUploadDate());
        fileObject.setStoredFilename(filenameToStore);
        fileObject.setProviderName(PROVIDER_NAME);
        fileObject.setImplementation(gridFSDBFile);
        return new DefaultStoreFileResponse(PROVIDER_NAME, (StoredFileObject)fileObject);
    }

    public StoreFileResponse store(File file, StoreFileRequest request) throws StoreFileException {
        try {
            return this.store(new FileInputStream(file), request);
        }
        catch (FileNotFoundException e) {
            throw new StoreFileException(file.getName() + " not found.", (Throwable)e);
        }
    }

    public StoreFileResponse store(byte[] bytes, StoreFileRequest request) throws StoreFileException {
        return this.store(new ByteArrayInputStream(bytes), request);
    }

    public StoredFileObject findByStoredFilename(String filename) {
        GridFSDBFile gridFSDBFile = this.gridFS.findOne(filename);
        if (gridFSDBFile == null) {
            return null;
        }
        DefaultStoredFileObject fileObject = new DefaultStoredFileObject();
        this.buildStoreFileObject(gridFSDBFile, fileObject);
        fileObject.setProviderName(PROVIDER_NAME);
        fileObject.setImplementation(gridFSDBFile);
        return fileObject;
    }

    public StoredFileObject findByStoredFilename(String filename, String downloadUrl) {
        logger.warn((Object)String.format("Caution: The download url[%s] will be skipped", downloadUrl));
        return this.findByStoredFilename(filename);
    }

    public StoredFileObject delete(String filename) {
        GridFSDBFile gridFSDBFile = this.gridFS.findOne(filename);
        if (gridFSDBFile == null) {
            return null;
        }
        DefaultStoredFileObject fileObject = new DefaultStoredFileObject();
        this.buildStoreFileObject(gridFSDBFile, fileObject);
        fileObject.setProviderName(PROVIDER_NAME);
        fileObject.setImplementation(null);
        try {
            this.gridFS.remove(filename);
            logger.info((Object)String.format("The gridfs file %s is deleted.", filename));
        }
        catch (Throwable e) {
            logger.error((Object)String.format("Delete gridfs file %s failed.", filename), e);
        }
        return fileObject;
    }

    private void buildStoreFileObject(GridFSDBFile gridFSDBFile, DefaultStoredFileObject fileObject) {
        fileObject.setUploadedAt(gridFSDBFile.getUploadDate());
        fileObject.setSize(gridFSDBFile.getChunkSize());
        fileObject.setStoredFilename(gridFSDBFile.getFilename());
        DBObject dbObject = gridFSDBFile.getMetaData();
        if (dbObject == null) {
            return;
        }
        try {
            fileObject.setOriginalFilename((String)dbObject.get("fss-originalFilename"));
            fileObject.setPrettyFilename((String)dbObject.get("fss-prettyFilename"));
            fileObject.setContentType((String)dbObject.get("fss-contentType"));
            fileObject.setUploadedBy((String)dbObject.get("fss-uploadedBy"));
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
        }
        try {
            HashMap attributes = new HashMap();
            dbObject.keySet().stream().filter(key -> key.startsWith("fss-attrs-")).forEach(key -> {
                String attributeName = key.substring("fss-attrs-".length());
                attributes.put(attributeName, (String)dbObject.get(key));
            });
            fileObject.setAttributes(attributes);
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        DB db = this.mongoDbFactory.getDb();
        this.gridFS = new GridFS(db, this.collectionName);
    }
}

