/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.fss.gridfs.impl;

import com.mongodb.gridfs.GridFSDBFile;
import in.clouthink.daas.fss.core.StoreFileRequest;
import in.clouthink.daas.fss.core.StoredFileObject;
import in.clouthink.daas.fss.domain.model.FileObject;
import in.clouthink.daas.fss.support.DefaultFileObject;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;

public class DefaultStoredFileObject
extends DefaultFileObject
implements StoredFileObject {
    private static final Log logger = LogFactory.getLog(DefaultStoredFileObject.class);
    private String providerName;
    private GridFSDBFile gridFSDBFile;

    public static DefaultStoredFileObject from(StoreFileRequest request) {
        if (request == null) {
            return null;
        }
        DefaultStoredFileObject result = new DefaultStoredFileObject();
        BeanUtils.copyProperties((Object)request, (Object)((Object)result));
        return result;
    }

    public static DefaultStoredFileObject from(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        DefaultStoredFileObject result = new DefaultStoredFileObject();
        BeanUtils.copyProperties((Object)fileObject, (Object)((Object)result));
        return result;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public GridFSDBFile getImplementation() {
        return this.gridFSDBFile;
    }

    public void setImplementation(GridFSDBFile gridFSDBFile) {
        this.gridFSDBFile = gridFSDBFile;
    }

    public void writeTo(OutputStream outputStream, int bufferSize) throws IOException {
        if (this.getImplementation() == null) {
            throw new UnsupportedOperationException("The stored file implementation is not supplied.");
        }
        logger.warn((Object)String.format("The bufferSize is not supported in current provider, the value[%d] will be ignored.", bufferSize));
        this.getImplementation().writeTo(outputStream);
    }

    public String toString() {
        return "DefaultStoredFileObject{providerName='" + this.providerName + '\'' + ", gridFSDBFile=" + this.gridFSDBFile + "} " + super.toString();
    }
}

