/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.fss.mongodb.spiImpl;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import in.clouthink.daas.edm.Edms;
import in.clouthink.daas.edm.EventListener;
import in.clouthink.daas.fss.core.FileObject;
import in.clouthink.daas.fss.core.FileStorage;
import in.clouthink.daas.fss.core.FileStorageException;
import in.clouthink.daas.fss.core.FileStorageMetadata;
import in.clouthink.daas.fss.core.FileStorageRequest;
import in.clouthink.daas.fss.mongodb.model.DefaultFileStorageMetadata;
import in.clouthink.daas.fss.mongodb.service.GridFSDBFileProvider;
import in.clouthink.daas.fss.mongodb.service.GridFSService;
import in.clouthink.daas.fss.mongodb.spiImpl.FileStorageImpl;
import in.clouthink.daas.fss.spi.FileObjectService;
import in.clouthink.daas.fss.spi.FileStorageService;
import java.io.InputStream;
import java.util.Date;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class FileStorageServiceImpl
implements FileStorageService,
EventListener<FileObject>,
InitializingBean {
    private final DefaultFileStorageMetadata metadata = new DefaultFileStorageMetadata();
    @Autowired
    private FileObjectService fileObjectService;
    @Autowired
    private GridFSService gridFSService;

    public FileStorageMetadata getStorageMetadata() {
        return this.metadata;
    }

    public FileStorage store(InputStream inputStream, FileStorageRequest request) {
        final in.clouthink.daas.fss.mongodb.model.FileObject fileObject = new in.clouthink.daas.fss.mongodb.model.FileObject();
        this.copy(request, fileObject);
        GridFSInputFile gridFSInputFile = this.storeFile(inputStream, request);
        this.fileObjectService.save((FileObject)fileObject);
        return new FileStorageImpl(fileObject, new GridFSDBFileProvider(){

            @Override
            public GridFSDBFile getGridFSDBFile() {
                return FileStorageServiceImpl.this.gridFSService.getGridFS().findOne(fileObject.getFinalFilename());
            }
        });
    }

    public FileStorage restore(String id, InputStream inputStream, FileStorageRequest request) {
        if (StringUtils.isEmpty((Object)id)) {
            throw new FileStorageException("The file object id is required.");
        }
        final in.clouthink.daas.fss.mongodb.model.FileObject fileObject = (in.clouthink.daas.fss.mongodb.model.FileObject)this.fileObjectService.findById(id);
        if (fileObject == null) {
            throw new FileStorageException("The file object of specified id is not found.");
        }
        GridFSInputFile gridFSInputFile = this.storeFile(inputStream, request);
        this.fileObjectService.saveAsHistory((FileObject)fileObject);
        this.merge(request, fileObject);
        this.fileObjectService.save((FileObject)fileObject);
        return new FileStorageImpl(fileObject, new GridFSDBFileProvider(){

            @Override
            public GridFSDBFile getGridFSDBFile() {
                return FileStorageServiceImpl.this.gridFSService.getGridFS().findOne(fileObject.getFinalFilename());
            }
        });
    }

    public FileStorage findById(String id) {
        final FileObject fileObject = this.fileObjectService.findById(id);
        if (fileObject == null) {
            return null;
        }
        return new FileStorageImpl(fileObject, new GridFSDBFileProvider(){

            @Override
            public GridFSDBFile getGridFSDBFile() {
                return FileStorageServiceImpl.this.gridFSService.getGridFS().findOne(fileObject.getFinalFilename());
            }
        });
    }

    public FileStorage findByFilename(String filename) {
        final FileObject fileObject = this.fileObjectService.findByFinalFilename(filename);
        if (fileObject == null) {
            return null;
        }
        return new FileStorageImpl(fileObject, new GridFSDBFileProvider(){

            @Override
            public GridFSDBFile getGridFSDBFile() {
                return FileStorageServiceImpl.this.gridFSService.getGridFS().findOne(fileObject.getFinalFilename());
            }
        });
    }

    public void onEvent(FileObject fileObject) {
        this.gridFSService.getGridFS().remove(fileObject.getFinalFilename());
    }

    public void afterPropertiesSet() throws Exception {
        Edms.getEdm().register("in.clouthink.daas.fss#delete", (Object)this);
    }

    private void copy(FileStorageRequest request, in.clouthink.daas.fss.mongodb.model.FileObject fileObject) {
        fileObject.setCode(request.getCode());
        fileObject.setBizId(request.getBizId());
        fileObject.setCategory(request.getCategory());
        fileObject.setAttributes(request.getAttributes());
        fileObject.setOriginalFilename(request.getOriginalFilename());
        fileObject.setPrettyFilename(request.getPrettyFilename());
        fileObject.setFinalFilename(request.getFinalFilename());
        fileObject.setContentType(request.getContentType());
        fileObject.setUploadedBy(request.getUploadedBy());
        fileObject.setUploadedAt(new Date());
        fileObject.setVersion(1);
    }

    private void merge(FileStorageRequest request, in.clouthink.daas.fss.mongodb.model.FileObject fileObject) {
        if (!StringUtils.isEmpty((Object)request.getCode())) {
            fileObject.setCode(request.getCode());
        }
        if (!StringUtils.isEmpty((Object)request.getBizId())) {
            fileObject.setBizId(request.getBizId());
        }
        if (!StringUtils.isEmpty((Object)request.getCategory())) {
            fileObject.setCategory(request.getCategory());
        }
        if (request.getAttributes() != null) {
            fileObject.getAttributes().putAll(request.getAttributes());
        }
        fileObject.setOriginalFilename(request.getOriginalFilename());
        fileObject.setPrettyFilename(request.getPrettyFilename());
        fileObject.setFinalFilename(request.getFinalFilename());
        fileObject.setContentType(request.getContentType());
        fileObject.setUploadedBy(request.getUploadedBy());
        fileObject.setUploadedAt(new Date());
        fileObject.setVersion(fileObject.getVersion() + 1);
    }

    private GridFSInputFile storeFile(InputStream inputStream, FileStorageRequest request) {
        GridFSInputFile gfsInputFile = this.gridFSService.getGridFS().createFile(inputStream);
        gfsInputFile.setFilename(request.getFinalFilename());
        gfsInputFile.setContentType(request.getContentType());
        if (request.getAttributes() != null) {
            BasicDBObject dbObject = new BasicDBObject(request.getAttributes());
            gfsInputFile.setMetaData((DBObject)dbObject);
        }
        gfsInputFile.save();
        return gfsInputFile;
    }
}

