/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.fss.mongodb.repository.custom.impl;

import in.clouthink.daas.fss.mongodb.model.FileObject;
import in.clouthink.daas.fss.mongodb.repository.FileObjectQueryParameter;
import in.clouthink.daas.fss.mongodb.repository.custom.FileObjectRepositoryCustom;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class FileObjectRepositoryImpl
implements FileObjectRepositoryCustom {
    @Autowired
    protected MongoTemplate mongoTemplate;

    @Override
    public Page<FileObject> findPage(FileObjectQueryParameter queryParameter, Pageable pageable) {
        Query query = this.buildQuery(queryParameter);
        query.with((Pageable)new PageRequest(pageable.getPageNumber(), pageable.getPageSize(), pageable.getSort()));
        long count = this.mongoTemplate.count(query, FileObject.class);
        List list = this.mongoTemplate.find(query, FileObject.class);
        return new PageImpl(list, pageable, count);
    }

    private Query buildQuery(FileObjectQueryParameter queryParameter) {
        Query query = new Query();
        String bizId = queryParameter.getBizId();
        String code = queryParameter.getCode();
        String category = queryParameter.getCategory();
        String uploadedBy = queryParameter.getUploadedBy();
        Date uploadedAtFrom = queryParameter.getUploadedAtFrom();
        Date uploadedAtTo = queryParameter.getUploadedAtTo();
        if (!StringUtils.isEmpty((Object)bizId)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"bizId").regex(bizId));
        }
        if (!StringUtils.isEmpty((Object)code)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"code").regex(code));
        }
        if (!StringUtils.isEmpty((Object)category)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"category").regex(category));
        }
        if (!StringUtils.isEmpty((Object)uploadedBy)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"uploadedBy").regex(uploadedBy));
        }
        if (uploadedAtFrom != null && uploadedAtTo != null) {
            Criteria criteria = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"uploadedAt").gte((Object)uploadedAtFrom), Criteria.where((String)"uploadedAt").lte((Object)uploadedAtTo)});
            query.addCriteria((CriteriaDefinition)criteria);
        } else if (uploadedAtFrom != null) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"uploadedAt").gte((Object)uploadedAtFrom));
        } else if (uploadedAtTo != null) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"uploadedAt").lte((Object)uploadedAtTo));
        }
        return query;
    }
}

