/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.fss.mongodb.spiImpl;

import in.clouthink.daas.edm.Edms;
import in.clouthink.daas.fss.core.FileObject;
import in.clouthink.daas.fss.core.FileStorageException;
import in.clouthink.daas.fss.mongodb.model.FileObjectHistory;
import in.clouthink.daas.fss.mongodb.repository.FileObjectHistoryRepository;
import in.clouthink.daas.fss.mongodb.repository.FileObjectRepository;
import in.clouthink.daas.fss.mongodb.service.FileObjectServiceExtension;
import in.clouthink.daas.fss.spi.FileObjectService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class FileObjectServiceImpl
implements FileObjectService,
FileObjectServiceExtension {
    @Autowired
    private FileObjectRepository fileObjectRepository;
    @Autowired
    private FileObjectHistoryRepository fileObjectHistoryRepository;

    public FileObject save(FileObject fileObject) {
        in.clouthink.daas.fss.mongodb.model.FileObject fileObjectImpl = (in.clouthink.daas.fss.mongodb.model.FileObject)fileObject;
        if (StringUtils.isEmpty((Object)fileObjectImpl.getOriginalFilename())) {
            throw new FileStorageException("The originalFilename is required.");
        }
        if (StringUtils.isEmpty((Object)fileObjectImpl.getUploadedBy())) {
            throw new FileStorageException("The uploadedBy is required.");
        }
        if (fileObjectImpl.getUploadedAt() == null) {
            fileObjectImpl.setUploadedAt(new Date());
        }
        if (StringUtils.isEmpty((Object)fileObjectImpl.getPrettyFilename())) {
            fileObjectImpl.setPrettyFilename(fileObjectImpl.getOriginalFilename());
        }
        if (fileObjectImpl.getVersion() == 0) {
            fileObjectImpl.setVersion(1);
        }
        return (FileObject)this.fileObjectRepository.save(fileObjectImpl);
    }

    public FileObject findById(String id) {
        return (FileObject)this.fileObjectRepository.findById(id);
    }

    public FileObject findByFinalFilename(String finalFilename) {
        return this.fileObjectRepository.findByFinalFilename(finalFilename);
    }

    public FileObject deleteById(String id) {
        in.clouthink.daas.fss.mongodb.model.FileObject result = (in.clouthink.daas.fss.mongodb.model.FileObject)this.fileObjectRepository.findById(id);
        if (result != null) {
            this.fileObjectRepository.delete(result);
            Edms.getEdm().dispatch("in.clouthink.daas.fss#delete", (Object)result);
        }
        return result;
    }

    public FileObject deleteByFinalFilename(String finalFilename) {
        in.clouthink.daas.fss.mongodb.model.FileObject result = this.fileObjectRepository.findByFinalFilename(finalFilename);
        if (result != null) {
            this.fileObjectRepository.delete(result);
            Edms.getEdm().dispatch("in.clouthink.daas.fss#delete", (Object)result);
        }
        return result;
    }

    public in.clouthink.daas.fss.core.FileObjectHistory saveAsHistory(FileObject fileObject) {
        in.clouthink.daas.fss.mongodb.model.FileObject fileObjectImpl = (in.clouthink.daas.fss.mongodb.model.FileObject)fileObject;
        FileObjectHistory result = new FileObjectHistory();
        result.setFileObject(fileObjectImpl);
        result.setFinalFilename(fileObjectImpl.getFinalFilename());
        result.setOriginalFilename(fileObjectImpl.getOriginalFilename());
        result.setPrettyFilename(fileObjectImpl.getPrettyFilename());
        result.setContentType(fileObjectImpl.getContentType());
        result.setUploadedBy(fileObjectImpl.getUploadedBy());
        result.setUploadedAt(fileObjectImpl.getUploadedAt());
        result.setVersion(fileObjectImpl.getVersion());
        return (in.clouthink.daas.fss.core.FileObjectHistory)this.fileObjectHistoryRepository.save(result);
    }

    public List<in.clouthink.daas.fss.core.FileObjectHistory> findHistoryById(String fileObjectId) {
        in.clouthink.daas.fss.mongodb.model.FileObject fileObjectImpl = (in.clouthink.daas.fss.mongodb.model.FileObject)this.fileObjectRepository.findById(fileObjectId);
        ArrayList<in.clouthink.daas.fss.core.FileObjectHistory> result = new ArrayList<in.clouthink.daas.fss.core.FileObjectHistory>();
        result.addAll(this.fileObjectHistoryRepository.findByFileObject(fileObjectImpl));
        return result;
    }
}

