/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.fss.mongodb.spiImpl;

import in.clouthink.daas.edm.Edms;
import in.clouthink.daas.fss.core.FileObject;
import in.clouthink.daas.fss.core.FileStorageException;
import in.clouthink.daas.fss.core.FileStorageRequest;
import in.clouthink.daas.fss.mongodb.model.FileObjectHistory;
import in.clouthink.daas.fss.mongodb.repository.FileObjectHistoryRepository;
import in.clouthink.daas.fss.mongodb.repository.FileObjectRepository;
import in.clouthink.daas.fss.spi.MutableFileObjectService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class FileObjectServiceImpl
implements MutableFileObjectService {
    @Autowired
    private FileObjectRepository fileObjectRepository;
    @Autowired
    private FileObjectHistoryRepository fileObjectHistoryRepository;

    public FileObject merge(FileStorageRequest request, FileObject fileObject) {
        if (StringUtils.isEmpty((Object)request.getOriginalFilename())) {
            throw new FileStorageException("The originalFilename is required.");
        }
        if (StringUtils.isEmpty((Object)request.getUploadedBy())) {
            throw new FileStorageException("The uploadedBy is required.");
        }
        in.clouthink.daas.fss.mongodb.model.FileObject fileObjectImpl = (in.clouthink.daas.fss.mongodb.model.FileObject)fileObject;
        fileObjectImpl.setOriginalFilename(request.getOriginalFilename());
        fileObjectImpl.setPrettyFilename(request.getPrettyFilename());
        fileObjectImpl.setContentType(request.getContentType());
        fileObjectImpl.setSize(request.getSize());
        fileObjectImpl.setUploadedBy(request.getUploadedBy());
        fileObjectImpl.setUploadedAt(new Date());
        if (StringUtils.isEmpty((Object)fileObjectImpl.getPrettyFilename())) {
            fileObjectImpl.setPrettyFilename(fileObjectImpl.getOriginalFilename());
        }
        if (fileObjectImpl.getVersion() == 0) {
            fileObjectImpl.setVersion(1);
        } else {
            fileObjectImpl.setVersion(fileObjectImpl.getVersion() + 1);
        }
        return fileObjectImpl;
    }

    public FileObject save(FileObject fileObject) {
        if (StringUtils.isEmpty((Object)fileObject.getOriginalFilename())) {
            throw new FileStorageException("The originalFilename is required.");
        }
        if (StringUtils.isEmpty((Object)fileObject.getUploadedBy())) {
            throw new FileStorageException("The uploadedBy is required.");
        }
        in.clouthink.daas.fss.mongodb.model.FileObject fileObjectImpl = null;
        fileObjectImpl = fileObject instanceof in.clouthink.daas.fss.mongodb.model.FileObject ? (in.clouthink.daas.fss.mongodb.model.FileObject)fileObject : in.clouthink.daas.fss.mongodb.model.FileObject.from(fileObject);
        if (fileObjectImpl.getUploadedAt() == null) {
            fileObjectImpl.setUploadedAt(new Date());
        }
        if (StringUtils.isEmpty((Object)fileObjectImpl.getPrettyFilename())) {
            fileObjectImpl.setPrettyFilename(fileObjectImpl.getOriginalFilename());
        }
        if (fileObjectImpl.getVersion() == 0) {
            fileObjectImpl.setVersion(1);
        }
        return (FileObject)this.fileObjectRepository.save(fileObjectImpl);
    }

    public FileObject findById(String id) {
        return (FileObject)this.fileObjectRepository.findById(id);
    }

    public FileObject findByFinalFilename(String finalFilename) {
        return this.fileObjectRepository.findByFinalFilename(finalFilename);
    }

    public FileObject deleteById(String id) {
        in.clouthink.daas.fss.mongodb.model.FileObject result = (in.clouthink.daas.fss.mongodb.model.FileObject)this.fileObjectRepository.findById(id);
        if (result != null) {
            this.fileObjectRepository.delete(result);
            Edms.getEdm().dispatch("in.clouthink.daas.fss#delete", (Object)result);
        }
        return result;
    }

    public in.clouthink.daas.fss.core.FileObjectHistory saveAsHistory(FileObject fileObject) {
        in.clouthink.daas.fss.mongodb.model.FileObject fileObjectImpl = null;
        fileObjectImpl = fileObject instanceof in.clouthink.daas.fss.mongodb.model.FileObject ? (in.clouthink.daas.fss.mongodb.model.FileObject)fileObject : in.clouthink.daas.fss.mongodb.model.FileObject.from(fileObject);
        FileObjectHistory result = FileObjectHistory.from(fileObjectImpl);
        return (in.clouthink.daas.fss.core.FileObjectHistory)this.fileObjectHistoryRepository.save(result);
    }

    public List<in.clouthink.daas.fss.core.FileObjectHistory> findHistoryById(String fileObjectId) {
        in.clouthink.daas.fss.mongodb.model.FileObject fileObjectImpl = (in.clouthink.daas.fss.mongodb.model.FileObject)this.fileObjectRepository.findById(fileObjectId);
        ArrayList<in.clouthink.daas.fss.core.FileObjectHistory> result = new ArrayList<in.clouthink.daas.fss.core.FileObjectHistory>();
        result.addAll(this.fileObjectHistoryRepository.findByFileObject(fileObjectImpl));
        return result;
    }
}

