/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.fss.mongodb.spiImpl;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import in.clouthink.daas.edm.Edms;
import in.clouthink.daas.edm.EventListener;
import in.clouthink.daas.fss.core.FileObject;
import in.clouthink.daas.fss.core.FileStorage;
import in.clouthink.daas.fss.core.FileStorageException;
import in.clouthink.daas.fss.core.FileStorageRequest;
import in.clouthink.daas.fss.core.MutableFileObject;
import in.clouthink.daas.fss.mongodb.service.GridFSService;
import in.clouthink.daas.fss.mongodb.spiImpl.FileStorageImpl;
import in.clouthink.daas.fss.repackage.org.apache.commons.io.FilenameUtils;
import in.clouthink.daas.fss.spi.FileStorageService;
import in.clouthink.daas.fss.spi.MutableFileObjectService;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class FileStorageServiceImpl
implements FileStorageService,
EventListener<FileObject>,
InitializingBean {
    private static final Log logger = LogFactory.getLog(FileStorageServiceImpl.class);
    @Autowired
    private MutableFileObjectService fileObjectService;
    @Autowired
    private GridFSService gridFSService;

    public Map<String, Object> buildExtraAttributes(FileObject fileObject) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("downloadUrl", String.format("/api/files/%s/download", fileObject.getId()));
        return result;
    }

    public FileStorage store(InputStream inputStream, FileStorageRequest request) {
        in.clouthink.daas.fss.mongodb.model.FileObject fileObject = this.createMongodbFileObject(request);
        this.updateGridfsPart(fileObject);
        fileObject = this.doStore(inputStream, (FileObject)fileObject);
        fileObject = this.fileObjectService.save((FileObject)fileObject);
        GridFSDBFile gridFSDBFile = this.gridFSService.getGridFS().findOne(fileObject.getFinalFilename());
        return new FileStorageImpl((FileObject)fileObject, gridFSDBFile);
    }

    public FileStorage restore(String id, InputStream inputStream, FileStorageRequest request) {
        if (StringUtils.isEmpty((Object)id)) {
            throw new FileStorageException("The file object id is required.");
        }
        FileObject fileObject = this.fileObjectService.findById(id);
        if (fileObject == null) {
            throw new FileStorageException("The file object of specified id is not found.");
        }
        this.fileObjectService.saveAsHistory(fileObject);
        fileObject = this.fileObjectService.merge(request, fileObject);
        this.updateGridfsPart((MutableFileObject)fileObject);
        fileObject = this.doStore(inputStream, fileObject);
        fileObject = this.fileObjectService.save(fileObject);
        GridFSDBFile gridFSDBFile = this.gridFSService.getGridFS().findOne(fileObject.getFinalFilename());
        return new FileStorageImpl(fileObject, gridFSDBFile);
    }

    public FileStorage findById(String id) {
        FileObject fileObject = this.fileObjectService.findById(id);
        if (fileObject == null) {
            return null;
        }
        GridFSDBFile gridFSDBFile = this.gridFSService.getGridFS().findOne(fileObject.getFinalFilename());
        return new FileStorageImpl(fileObject, gridFSDBFile);
    }

    public FileStorage findByFilename(String filename) {
        FileObject fileObject = this.fileObjectService.findByFinalFilename(filename);
        if (fileObject == null) {
            return null;
        }
        GridFSDBFile gridFSDBFile = this.gridFSService.getGridFS().findOne(fileObject.getFinalFilename());
        return new FileStorageImpl(fileObject, gridFSDBFile);
    }

    public void onEvent(FileObject fileObject) {
        this.gridFSService.getGridFS().remove(fileObject.getFinalFilename());
    }

    private in.clouthink.daas.fss.mongodb.model.FileObject createMongodbFileObject(FileStorageRequest request) {
        if (StringUtils.isEmpty((Object)request.getOriginalFilename())) {
            throw new FileStorageException("The originalFilename is required.");
        }
        if (StringUtils.isEmpty((Object)request.getUploadedBy())) {
            throw new FileStorageException("The uploadedBy is required.");
        }
        in.clouthink.daas.fss.mongodb.model.FileObject fileObject = in.clouthink.daas.fss.mongodb.model.FileObject.from(request);
        if (StringUtils.isEmpty((Object)fileObject.getPrettyFilename())) {
            fileObject.setPrettyFilename(fileObject.getOriginalFilename());
        }
        fileObject.setVersion(1);
        Date uploadedAt = new Date();
        fileObject.setUploadedAt(uploadedAt);
        return fileObject;
    }

    private void updateGridfsPart(MutableFileObject fileObject) {
        String finalFilename = UUID.randomUUID().toString().replace("-", "");
        String extName = FilenameUtils.getExtension((String)fileObject.getOriginalFilename());
        if (!StringUtils.isEmpty((Object)extName)) {
            finalFilename = finalFilename + "." + extName;
        }
        fileObject.setFinalFilename(finalFilename);
        fileObject.getAttributes().put("fss-provider", "gridfs");
    }

    private FileObject doStore(InputStream inputStream, FileObject fileObject) {
        GridFSInputFile gfsInputFile = this.gridFSService.getGridFS().createFile(inputStream);
        gfsInputFile.setFilename(fileObject.getFinalFilename());
        gfsInputFile.setContentType(fileObject.getContentType());
        if (fileObject.getAttributes() != null) {
            BasicDBObject dbObject = new BasicDBObject(fileObject.getAttributes());
            gfsInputFile.setMetaData((DBObject)dbObject);
        }
        gfsInputFile.save();
        return fileObject;
    }

    public void afterPropertiesSet() throws Exception {
        Edms.getEdm().register("in.clouthink.daas.fss#delete", (Object)this);
    }
}

