/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.fss.mongodb.impl;

import in.clouthink.daas.fss.domain.model.FileObject;
import in.clouthink.daas.fss.domain.request.FileObjectSaveRequest;
import in.clouthink.daas.fss.domain.service.FileObjectService;
import in.clouthink.daas.fss.mongodb.model.FileObjectHistory;
import in.clouthink.daas.fss.mongodb.model.FileObjectSearchRequest;
import in.clouthink.daas.fss.mongodb.repository.FileObjectHistoryRepository;
import in.clouthink.daas.fss.mongodb.repository.FileObjectRepository;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;

public class FileObjectServiceImpl
implements FileObjectService {
    @Autowired
    private FileObjectHistoryRepository fileObjectHistoryRepository;
    @Autowired
    private FileObjectRepository fileObjectRepository;

    public FileObject findById(String id) {
        return (FileObject)this.fileObjectRepository.findById(id);
    }

    public FileObject findByStoredFilename(String storedFileName) {
        return this.fileObjectRepository.findByStoredFilename(storedFileName);
    }

    public List<in.clouthink.daas.fss.domain.model.FileObjectHistory> findHistoryByFileObjectId(String id) {
        return this.fileObjectHistoryRepository.findByFileObjectId(id).stream().map(item -> item).collect(Collectors.toList());
    }

    public FileObject save(FileObjectSaveRequest storeFileRequest) {
        in.clouthink.daas.fss.mongodb.model.FileObject fileObject = new in.clouthink.daas.fss.mongodb.model.FileObject();
        BeanUtils.copyProperties((Object)storeFileRequest, (Object)fileObject, (String[])new String[]{"id"});
        return (FileObject)this.fileObjectRepository.save(fileObject);
    }

    public in.clouthink.daas.fss.domain.model.FileObjectHistory saveAsHistory(FileObject fileObject) {
        in.clouthink.daas.fss.mongodb.model.FileObject mongodbFileObject = (in.clouthink.daas.fss.mongodb.model.FileObject)fileObject;
        FileObjectHistory result = FileObjectHistory.from(mongodbFileObject);
        return (in.clouthink.daas.fss.domain.model.FileObjectHistory)this.fileObjectHistoryRepository.save(result);
    }

    public FileObject deleteById(String id) {
        in.clouthink.daas.fss.mongodb.model.FileObject result = (in.clouthink.daas.fss.mongodb.model.FileObject)this.fileObjectRepository.findById(id);
        if (result == null) {
            return null;
        }
        this.fileObjectHistoryRepository.deleteByFileObjectId(id);
        this.fileObjectRepository.delete(result);
        return result;
    }

    public FileObject deleteByStoredFilename(String storedFileName) {
        in.clouthink.daas.fss.mongodb.model.FileObject result = this.fileObjectRepository.findByStoredFilename(storedFileName);
        if (result == null) {
            return null;
        }
        this.fileObjectHistoryRepository.deleteByFileObject(result);
        this.fileObjectRepository.delete(result);
        return result;
    }

    public Page<FileObject> search(in.clouthink.daas.fss.domain.request.FileObjectSearchRequest searchRequest) {
        return this.fileObjectRepository.findPage((FileObjectSearchRequest)searchRequest).map(item -> item);
    }
}

