/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.fss.mongodb.repository.custom.impl;

import in.clouthink.daas.fss.mongodb.model.FileObject;
import in.clouthink.daas.fss.mongodb.model.FileObjectSearchRequest;
import in.clouthink.daas.fss.mongodb.repository.custom.FileObjectRepositoryCustom;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class FileObjectRepositoryImpl
implements FileObjectRepositoryCustom {
    @Autowired
    protected MongoTemplate mongoTemplate;

    @Override
    public Page<FileObject> findPage(FileObjectSearchRequest searchRequest) {
        Pageable pageable = searchRequest.toPageable();
        Query query = this.buildQuery(searchRequest);
        query.with(pageable);
        return PageableExecutionUtils.getPage((List)this.mongoTemplate.find(query, FileObject.class), (Pageable)pageable, () -> this.mongoTemplate.count(query, FileObject.class));
    }

    private Query buildQuery(FileObjectSearchRequest searchRequest) {
        Query query = new Query();
        String attachedId = searchRequest.getAttachedId();
        String code = searchRequest.getCode();
        String category = searchRequest.getCategory();
        String uploadedBy = searchRequest.getUploadedBy();
        Date uploadedAtFrom = searchRequest.getUploadedAtFrom();
        Date uploadedAtTo = searchRequest.getUploadedAtTo();
        if (!StringUtils.isEmpty((Object)attachedId)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"attachedId").regex(attachedId));
        }
        if (!StringUtils.isEmpty((Object)code)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"code").regex(code));
        }
        if (!StringUtils.isEmpty((Object)category)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"category").regex(category));
        }
        if (!StringUtils.isEmpty((Object)uploadedBy)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"uploadedBy").regex(uploadedBy));
        }
        if (uploadedAtFrom != null && uploadedAtTo != null) {
            Criteria criteria = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"uploadedAt").gte((Object)uploadedAtFrom), Criteria.where((String)"uploadedAt").lte((Object)uploadedAtTo)});
            query.addCriteria((CriteriaDefinition)criteria);
        } else if (uploadedAtFrom != null) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"uploadedAt").gte((Object)uploadedAtFrom));
        } else if (uploadedAtTo != null) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"uploadedAt").lte((Object)uploadedAtTo));
        }
        return query;
    }
}

