/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.fss.mysql.impl;

import in.clouthink.daas.fss.domain.model.FileObjectHistory;
import in.clouthink.daas.fss.domain.request.FileObjectSaveRequest;
import in.clouthink.daas.fss.domain.service.FileObjectService;
import in.clouthink.daas.fss.mysql.model.FileObject;
import in.clouthink.daas.fss.mysql.model.FileObjectSearchRequest;
import in.clouthink.daas.fss.mysql.repository.FileObjectAttributeRepository;
import in.clouthink.daas.fss.mysql.repository.FileObjectHistoryRepository;
import in.clouthink.daas.fss.mysql.repository.FileObjectRepository;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class FileObjectServiceImpl
implements FileObjectService {
    @Autowired
    private FileObjectAttributeRepository fileObjectAttributeRepository;
    @Autowired
    private FileObjectHistoryRepository fileObjectHistoryRepository;
    @Autowired
    private FileObjectRepository fileObjectRepository;

    public in.clouthink.daas.fss.domain.model.FileObject findById(String id) {
        return (in.clouthink.daas.fss.domain.model.FileObject)this.fileObjectRepository.findById(id);
    }

    public in.clouthink.daas.fss.domain.model.FileObject findByStoredFilename(String storedFileName) {
        return this.fileObjectRepository.findByStoredFilename(storedFileName);
    }

    public List<FileObjectHistory> findHistoryByFileObjectId(String id) {
        return this.fileObjectHistoryRepository.findByFileObjectId(id).stream().map(item -> item).collect(Collectors.toList());
    }

    public in.clouthink.daas.fss.domain.model.FileObject save(FileObjectSaveRequest storeFileRequest) {
        FileObject fileObject = new FileObject();
        BeanUtils.copyProperties((Object)storeFileRequest, (Object)fileObject, (String[])new String[]{"id"});
        return (in.clouthink.daas.fss.domain.model.FileObject)this.fileObjectRepository.save(fileObject);
    }

    public FileObjectHistory saveAsHistory(in.clouthink.daas.fss.domain.model.FileObject fileObject) {
        FileObject mysqlFileObject = (FileObject)fileObject;
        in.clouthink.daas.fss.mysql.model.FileObjectHistory result = in.clouthink.daas.fss.mysql.model.FileObjectHistory.from(mysqlFileObject);
        return (FileObjectHistory)this.fileObjectHistoryRepository.save(result);
    }

    public in.clouthink.daas.fss.domain.model.FileObject deleteById(String id) {
        FileObject result = (FileObject)this.fileObjectRepository.findById(id);
        if (result == null) {
            return null;
        }
        this.fileObjectAttributeRepository.deleteByFileObjectId(id);
        this.fileObjectHistoryRepository.deleteByFileObjectId(id);
        this.fileObjectRepository.delete(result);
        return result;
    }

    public in.clouthink.daas.fss.domain.model.FileObject deleteByStoredFilename(String storedFileName) {
        FileObject result = this.fileObjectRepository.findByStoredFilename(storedFileName);
        if (result == null) {
            return null;
        }
        this.fileObjectAttributeRepository.deleteByFileObject(result);
        this.fileObjectHistoryRepository.deleteByFileObject(result);
        this.fileObjectRepository.delete(result);
        return result;
    }

    public Page<in.clouthink.daas.fss.domain.model.FileObject> search(in.clouthink.daas.fss.domain.request.FileObjectSearchRequest searchRequest) {
        return this.fileObjectRepository.findPage((FileObjectSearchRequest)searchRequest).map(item -> item);
    }
}

