/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.fss.mysql.impl;

import in.clouthink.daas.fss.domain.model.FileObjectHistory;
import in.clouthink.daas.fss.domain.request.FileObjectSaveRequest;
import in.clouthink.daas.fss.domain.service.FileObjectService;
import in.clouthink.daas.fss.mysql.model.FileObject;
import in.clouthink.daas.fss.mysql.model.FileObjectAttribute;
import in.clouthink.daas.fss.mysql.model.FileObjectSearchRequest;
import in.clouthink.daas.fss.mysql.repository.FileObjectAttributeRepository;
import in.clouthink.daas.fss.mysql.repository.FileObjectHistoryRepository;
import in.clouthink.daas.fss.mysql.repository.FileObjectRepository;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class FileObjectServiceImpl
implements FileObjectService {
    @Autowired
    private FileObjectAttributeRepository fileObjectAttributeRepository;
    @Autowired
    private FileObjectHistoryRepository fileObjectHistoryRepository;
    @Autowired
    private FileObjectRepository fileObjectRepository;

    public in.clouthink.daas.fss.domain.model.FileObject findById(String id) {
        FileObject result = (FileObject)this.fileObjectRepository.findById(id);
        if (result == null) {
            return null;
        }
        List<FileObjectAttribute> fileObjectAttributes = this.fileObjectAttributeRepository.findListByFileObject(result);
        HashMap<String, String> attributes = new HashMap<String, String>();
        fileObjectAttributes.forEach(item -> attributes.put(item.getKey(), item.getValue()));
        result.setAttributes(attributes);
        return result;
    }

    public in.clouthink.daas.fss.domain.model.FileObject findByStoredFilename(String storedFileName) {
        return this.fileObjectRepository.findByStoredFilename(storedFileName);
    }

    public List<FileObjectHistory> findHistoryByFileObjectId(String id) {
        return this.fileObjectHistoryRepository.findByFileObjectId(id).stream().map(item -> item).collect(Collectors.toList());
    }

    public in.clouthink.daas.fss.domain.model.FileObject save(FileObjectSaveRequest storeFileRequest) {
        if (storeFileRequest.getAttributes() != null && storeFileRequest.getAttributes().size() > 25) {
            throw new IllegalArgumentException("The count of customized attributes can't be exceed 25.");
        }
        FileObject fileObject = new FileObject();
        BeanUtils.copyProperties((Object)storeFileRequest, (Object)fileObject, (String[])new String[]{"id"});
        in.clouthink.daas.fss.domain.model.FileObject result = (in.clouthink.daas.fss.domain.model.FileObject)this.fileObjectRepository.save(fileObject);
        storeFileRequest.getAttributes().forEach((key, value) -> {
            FileObjectAttribute attribute = new FileObjectAttribute();
            attribute.setKey((String)key);
            attribute.setValue((String)value);
            attribute.setFileObject(fileObject);
            this.fileObjectAttributeRepository.save(attribute);
        });
        return result;
    }

    public FileObjectHistory saveAsHistory(in.clouthink.daas.fss.domain.model.FileObject fileObject) {
        FileObject mysqlFileObject = (FileObject)fileObject;
        in.clouthink.daas.fss.mysql.model.FileObjectHistory result = in.clouthink.daas.fss.mysql.model.FileObjectHistory.from(mysqlFileObject);
        return (FileObjectHistory)this.fileObjectHistoryRepository.save(result);
    }

    public in.clouthink.daas.fss.domain.model.FileObject deleteById(String id) {
        FileObject result = (FileObject)this.fileObjectRepository.findById(id);
        if (result == null) {
            return null;
        }
        this.fileObjectAttributeRepository.deleteByFileObjectId(id);
        this.fileObjectHistoryRepository.deleteByFileObjectId(id);
        this.fileObjectRepository.delete(result);
        return result;
    }

    public in.clouthink.daas.fss.domain.model.FileObject deleteByStoredFilename(String storedFileName) {
        FileObject result = this.fileObjectRepository.findByStoredFilename(storedFileName);
        if (result == null) {
            return null;
        }
        this.fileObjectAttributeRepository.deleteByFileObject(result);
        this.fileObjectHistoryRepository.deleteByFileObject(result);
        this.fileObjectRepository.delete(result);
        return result;
    }

    public Page<in.clouthink.daas.fss.domain.model.FileObject> search(in.clouthink.daas.fss.domain.request.FileObjectSearchRequest searchRequest) {
        return this.fileObjectRepository.findPage((FileObjectSearchRequest)searchRequest).map(item -> item);
    }
}

