package in.clouthink.daas.fss.mysql.repository;

import in.clouthink.daas.fss.mysql.model.FileObject;
import in.clouthink.daas.fss.mysql.repository.custom.FileObjectRepositoryCustom;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.Date;

/**
 * @author dz
 */
public interface FileObjectRepository extends AbstractRepository<FileObject>, FileObjectRepositoryCustom {

    FileObject findByStoredFilename(String finalFilename);

    Page<FileObject> findByCategory(String category, Pageable pageable);

    Page<FileObject> findByUploadedBy(String uploadedBy, Pageable pageable);

    Page<FileObject> findByUploadedAtBetween(Date start, Date end, Pageable pageable);

    Page<FileObject> findByAttachedId(String attachedId, Pageable pageable);

}
