/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.fss.qiniu.impl;

import com.google.gson.Gson;
import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.DefaultPutRet;
import com.qiniu.storage.model.FileInfo;
import com.qiniu.util.Auth;
import in.clouthink.daas.fss.core.FileStorage;
import in.clouthink.daas.fss.core.StoreFileException;
import in.clouthink.daas.fss.core.StoreFileRequest;
import in.clouthink.daas.fss.core.StoreFileResponse;
import in.clouthink.daas.fss.core.StoredFileObject;
import in.clouthink.daas.fss.qiniu.exception.QiniuStoreException;
import in.clouthink.daas.fss.qiniu.impl.DefaultStoredFileObject;
import in.clouthink.daas.fss.qiniu.impl.QiniuFile;
import in.clouthink.daas.fss.qiniu.support.QiniuProperties;
import in.clouthink.daas.fss.support.DefaultStoreFileResponse;
import in.clouthink.daas.fss.util.MetadataUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FileStorageImpl
implements FileStorage,
InitializingBean {
    private static final Log logger = LogFactory.getLog(FileStorageImpl.class);
    public static final String PROVIDER_NAME = "qiniu";
    @Autowired
    private QiniuProperties qiniuProperties;
    private Auth auth;
    private UploadManager uploadManager;
    private BucketManager bucketManager;

    public QiniuProperties getQiniuProperties() {
        return this.qiniuProperties;
    }

    public String getName() {
        return PROVIDER_NAME;
    }

    public boolean isMetadataSupported() {
        return false;
    }

    public StoreFileResponse store(InputStream inputStream, StoreFileRequest request) throws StoreFileException {
        String qiniuKey = MetadataUtils.generateFilename((StoreFileRequest)request);
        String qiniuBucket = this.resolveBucket(request);
        try {
            String upToken = this.auth.uploadToken(qiniuBucket);
            Response res = this.uploadManager.put(inputStream, qiniuKey, upToken, null, request.getContentType());
            if (!res.isOK()) {
                throw new QiniuStoreException(res.toString());
            }
            DefaultPutRet uploadResult = (DefaultPutRet)new Gson().fromJson(res.bodyString(), DefaultPutRet.class);
            logger.debug((Object)String.format("%s is uploaded and stored as %s", request.getOriginalFilename(), uploadResult.key));
            long size = request.getSize();
            if (request.getSize() <= 0L) {
                try {
                    FileInfo fileInfo = this.bucketManager.stat(qiniuBucket, qiniuKey);
                    if (fileInfo != null) {
                        size = fileInfo.fsize;
                    }
                }
                catch (Throwable fileInfo) {
                    // empty catch block
                }
            }
            DefaultStoredFileObject fileObject = DefaultStoredFileObject.from(request);
            String url = "https://" + this.qiniuProperties.getHost() + "/" + uploadResult.key;
            fileObject.getAttributes().put("qiniu-bucket", qiniuBucket);
            fileObject.getAttributes().put("qiniu-key", uploadResult.key);
            fileObject.getAttributes().put("qiniu-url", url);
            fileObject.setSize(size);
            fileObject.setUploadedAt(new Date());
            fileObject.setFileUrl(url);
            fileObject.setStoredFilename(qiniuBucket + ":" + uploadResult.key);
            fileObject.setProviderName(PROVIDER_NAME);
            fileObject.setImplementation(new QiniuFile(url, this.auth));
            return new DefaultStoreFileResponse(PROVIDER_NAME, (StoredFileObject)fileObject);
        }
        catch (QiniuStoreException e) {
            throw e;
        }
        catch (QiniuException e) {
            String message;
            Response r = e.response;
            try {
                message = r.bodyString();
            }
            catch (Exception ex) {
                message = ex.toString();
            }
            throw new QiniuStoreException(message);
        }
        catch (Throwable e) {
            throw new QiniuStoreException(String.format("Fail to upload file %s", request.getOriginalFilename()), e);
        }
    }

    public StoreFileResponse store(File file, StoreFileRequest request) throws StoreFileException {
        try {
            return this.store(new FileInputStream(file), request);
        }
        catch (FileNotFoundException e) {
            throw new QiniuStoreException(file.getName() + " not found.", e);
        }
    }

    public StoreFileResponse store(byte[] bytes, StoreFileRequest request) throws StoreFileException {
        return this.store(new ByteArrayInputStream(bytes), request);
    }

    public StoredFileObject findByStoredFilename(String filename) {
        return this.findByStoredFilename(filename, null);
    }

    public StoredFileObject findByStoredFilename(String filename, String downloadUrl) {
        if (StringUtils.isEmpty((Object)filename)) {
            return null;
        }
        if (filename.indexOf("?") > 0) {
            filename = filename.substring(0, filename.indexOf("?"));
        }
        if (filename.indexOf(":") <= 0) {
            throw new QiniuStoreException(String.format("Invalid filename %s , the format should be bucket:key", filename));
        }
        String qiniuBucket = filename.split(":")[0];
        String qiniuKey = filename.split(":")[1];
        try {
            FileInfo fileInfo = this.bucketManager.stat(qiniuBucket, qiniuKey);
            if (fileInfo == null) {
                return null;
            }
            DefaultStoredFileObject fileObject = new DefaultStoredFileObject();
            String url = downloadUrl;
            if (StringUtils.isEmpty((Object)url)) {
                url = "http://" + this.qiniuProperties.getHost() + "/" + qiniuKey;
            }
            fileObject.setFileUrl(url);
            fileObject.setSize(fileInfo.fsize);
            fileObject.setContentType(fileInfo.mimeType);
            fileObject.setUploadedAt(new Date(fileInfo.putTime));
            fileObject.setProviderName(PROVIDER_NAME);
            fileObject.setImplementation(new QiniuFile(url, this.auth));
            return fileObject;
        }
        catch (QiniuException e) {
            String message;
            Response r = e.response;
            try {
                message = r.bodyString();
            }
            catch (Exception ex) {
                message = ex.toString();
            }
            throw new QiniuStoreException(message);
        }
        catch (Throwable e) {
            logger.error((Object)String.format("Fail to get the file[bucket=%s,key=%s]", qiniuBucket, qiniuKey), e);
            return null;
        }
    }

    public StoredFileObject delete(String filename) {
        if (StringUtils.isEmpty((Object)filename)) {
            return null;
        }
        if (filename.indexOf("?") > 0) {
            filename = filename.substring(0, filename.indexOf("?"));
        }
        if (filename.indexOf(":") <= 0) {
            throw new QiniuStoreException(String.format("Invalid filename %s , the format should be bucket:key", filename));
        }
        String qiniuBucket = filename.split(":")[0];
        String qiniuKey = filename.split(":")[1];
        try {
            FileInfo fileInfo = this.bucketManager.stat(qiniuBucket, qiniuKey);
            if (fileInfo == null) {
                return null;
            }
            DefaultStoredFileObject fileObject = new DefaultStoredFileObject();
            fileObject.getAttributes().put("qiniu-bucket", qiniuBucket);
            fileObject.getAttributes().put("qiniu-key", qiniuKey);
            fileObject.setSize(fileInfo.fsize);
            fileObject.setContentType(fileInfo.mimeType);
            fileObject.setUploadedAt(new Date(fileInfo.putTime));
            fileObject.setProviderName(PROVIDER_NAME);
            fileObject.setImplementation(null);
            this.bucketManager.delete(qiniuBucket, qiniuKey);
            logger.info((Object)String.format("The qiniu file[bucket=%s,key=%s] is deleted.", qiniuBucket, qiniuKey));
            return fileObject;
        }
        catch (QiniuException e) {
            String message;
            Response r = e.response;
            try {
                message = r.bodyString();
            }
            catch (Exception ex) {
                message = ex.toString();
            }
            throw new QiniuStoreException(message);
        }
        catch (Throwable e) {
            logger.error((Object)String.format("Fail to delete the file[bucket=%s,key=%s]", qiniuBucket, qiniuKey), e);
            return null;
        }
    }

    private String resolveBucket(StoreFileRequest request) {
        String category = (String)request.getAttributes().get("category");
        String bucket = this.qiniuProperties.getBuckets().get(category);
        if (StringUtils.isEmpty((Object)bucket)) {
            bucket = this.qiniuProperties.getDefaultBucket();
        }
        return bucket;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.qiniuProperties);
        this.auth = Auth.create((String)this.qiniuProperties.getAccessKey(), (String)this.qiniuProperties.getSecretKey());
        Zone z = Zone.autoZone();
        Configuration c = new Configuration(z);
        this.uploadManager = new UploadManager(c);
        this.bucketManager = new BucketManager(this.auth, c);
    }
}

