/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.fss.qiniu.impl;

import in.clouthink.daas.fss.core.StoreFileRequest;
import in.clouthink.daas.fss.core.StoredFileObject;
import in.clouthink.daas.fss.domain.model.FileObject;
import in.clouthink.daas.fss.qiniu.impl.QiniuFile;
import in.clouthink.daas.fss.support.DefaultFileObject;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;

public class DefaultStoredFileObject
extends DefaultFileObject
implements StoredFileObject {
    private static final Log logger = LogFactory.getLog(DefaultStoredFileObject.class);
    private String providerName;
    private QiniuFile qiniuFile;

    public static DefaultStoredFileObject from(StoreFileRequest request) {
        if (request == null) {
            return null;
        }
        DefaultStoredFileObject result = new DefaultStoredFileObject();
        BeanUtils.copyProperties((Object)request, (Object)((Object)result));
        return result;
    }

    public static DefaultStoredFileObject from(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        DefaultStoredFileObject result = new DefaultStoredFileObject();
        BeanUtils.copyProperties((Object)fileObject, (Object)((Object)result));
        return result;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public QiniuFile getImplementation() {
        return this.qiniuFile;
    }

    public void setImplementation(QiniuFile qiniuFile) {
        this.qiniuFile = qiniuFile;
    }

    public void writeTo(OutputStream outputStream, int bufferSize) throws IOException {
        if (this.getImplementation() == null) {
            throw new UnsupportedOperationException("The stored file implementation is not supplied.");
        }
        if (bufferSize <= 0) {
            bufferSize = 4096;
        }
        this.qiniuFile.writeTo(outputStream, bufferSize);
    }

    public String toString() {
        return "DefaultStoredFileObject{providerName='" + this.providerName + '\'' + ", qiniuFile=" + this.qiniuFile + "} " + super.toString();
    }
}

