/*
 * Decompiled with CFR 0.152.
 */
package in.clouthink.daas.fss.s3.impl;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import in.clouthink.daas.fss.core.FileStorage;
import in.clouthink.daas.fss.core.StoreFileException;
import in.clouthink.daas.fss.core.StoreFileRequest;
import in.clouthink.daas.fss.core.StoreFileResponse;
import in.clouthink.daas.fss.core.StoredFileObject;
import in.clouthink.daas.fss.s3.exception.S3StoreException;
import in.clouthink.daas.fss.s3.impl.DefaultStoredFileObject;
import in.clouthink.daas.fss.s3.impl.S3ObjectProxy;
import in.clouthink.daas.fss.s3.support.S3Properties;
import in.clouthink.daas.fss.support.DefaultStoreFileResponse;
import in.clouthink.daas.fss.util.MetadataUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FileStorageImpl
implements FileStorage,
InitializingBean {
    private static final Log logger = LogFactory.getLog(FileStorageImpl.class);
    public static final String PROVIDER_NAME = "s3";
    @Autowired
    private S3Properties s3Properties;
    private AmazonS3 s3Client;

    public S3Properties getS3Properties() {
        return this.s3Properties;
    }

    public AmazonS3 getS3Client() {
        return this.s3Client;
    }

    public String getName() {
        return PROVIDER_NAME;
    }

    public boolean isMetadataSupported() {
        return true;
    }

    public StoreFileResponse store(InputStream inputStream, StoreFileRequest request) throws StoreFileException {
        String s3Bucket = this.resolveBucket(request);
        String s3ObjectKey = MetadataUtils.generateFilename((StoreFileRequest)request);
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentType(request.getContentType());
        objectMetadata.setUserMetadata(MetadataUtils.buildMetadata((StoreFileRequest)request));
        PutObjectRequest putObjectRequest = new PutObjectRequest(s3Bucket, s3ObjectKey, inputStream, objectMetadata);
        putObjectRequest.getRequestClientOptions().setReadLimit(50000000);
        PutObjectResult putObjectResult = this.s3Client.putObject(putObjectRequest);
        logger.debug((Object)String.format("%s is stored", s3ObjectKey));
        S3Object s3Object = this.s3Client.getObject(s3Bucket, s3ObjectKey);
        DefaultStoredFileObject fileObject = DefaultStoredFileObject.from(request);
        fileObject.getAttributes().put("s3-bucket", s3Bucket);
        fileObject.getAttributes().put("s3-key", s3ObjectKey);
        String uploadedAt = (String)objectMetadata.getUserMetadata().get("fss-uploadedAt");
        fileObject.setUploadedAt(uploadedAt != null ? new Date(Long.parseLong(uploadedAt)) : null);
        fileObject.setStoredFilename(s3Bucket + ":" + s3ObjectKey);
        fileObject.setProviderName(PROVIDER_NAME);
        fileObject.setImplementation(new S3ObjectProxy(s3Object));
        return new DefaultStoreFileResponse(PROVIDER_NAME, (StoredFileObject)fileObject);
    }

    public StoreFileResponse store(File file, StoreFileRequest request) throws StoreFileException {
        try {
            return this.store(new FileInputStream(file), request);
        }
        catch (FileNotFoundException e) {
            throw new S3StoreException(file.getName() + " not found.", e);
        }
    }

    public StoreFileResponse store(byte[] bytes, StoreFileRequest request) throws StoreFileException {
        return this.store(new ByteArrayInputStream(bytes), request);
    }

    public StoredFileObject findByStoredFilename(String filename) {
        String s3ObjectKey;
        if (StringUtils.isEmpty((Object)filename)) {
            return null;
        }
        if (filename.indexOf("?") > 0) {
            filename = filename.substring(0, filename.indexOf("?"));
        }
        if (filename.indexOf(":") <= 0) {
            throw new S3StoreException(String.format("Invalid filename %s , the format should be bucket_name:object_key", filename));
        }
        String s3Bucket = filename.split(":")[0];
        S3Object s3Object = this.s3Client.getObject(s3Bucket, s3ObjectKey = filename.split(":")[1]);
        if (s3Object == null) {
            return null;
        }
        DefaultStoredFileObject fileObject = new DefaultStoredFileObject();
        this.buildStoreFileObject(s3Object, fileObject);
        String fileUrl = (String)s3Object.getObjectMetadata().getUserMetadata().get("s3-url");
        fileObject.setFileUrl(fileUrl);
        fileObject.setStoredFilename(filename);
        fileObject.setProviderName(PROVIDER_NAME);
        fileObject.setImplementation(new S3ObjectProxy(s3Object));
        return fileObject;
    }

    public StoredFileObject findByStoredFilename(String filename, String downloadUrl) {
        logger.warn((Object)String.format("Caution: The download url[%s] will be skipped", downloadUrl));
        return this.findByStoredFilename(filename);
    }

    public StoredFileObject delete(String filename) {
        String s3ObjectKey;
        if (StringUtils.isEmpty((Object)filename)) {
            return null;
        }
        if (filename.indexOf("?") > 0) {
            filename = filename.substring(0, filename.indexOf("?"));
        }
        if (filename.indexOf(":") <= 0) {
            throw new S3StoreException(String.format("Invalid filename %s , the format should be bucket_name:object_key", filename));
        }
        String s3Bucket = filename.split(":")[0];
        S3Object s3Object = this.s3Client.getObject(s3Bucket, s3ObjectKey = filename.split(":")[1]);
        if (s3Object == null) {
            return null;
        }
        DefaultStoredFileObject fileObject = new DefaultStoredFileObject();
        this.buildStoreFileObject(s3Object, fileObject);
        fileObject.setStoredFilename(filename);
        fileObject.setProviderName(PROVIDER_NAME);
        fileObject.setImplementation(null);
        try {
            this.s3Client.deleteObject(s3Bucket, s3ObjectKey);
            logger.info((Object)String.format("The s3-object[bucket=%s,key=%s] is deleted.", s3Bucket, s3ObjectKey));
        }
        catch (Throwable e) {
            logger.error((Object)String.format("Delete the s3-object[bucket=%s,key=%s] failed.", s3Bucket, s3ObjectKey), e);
        }
        return fileObject;
    }

    private void buildStoreFileObject(S3Object s3Object, DefaultStoredFileObject fileObject) {
        Map userMetadata = s3Object.getObjectMetadata().getUserMetadata();
        if (userMetadata == null) {
            return;
        }
        try {
            fileObject.setStoredFilename(s3Object.getKey());
            fileObject.setOriginalFilename((String)userMetadata.get("fss-originalFilename"));
            fileObject.setPrettyFilename((String)userMetadata.get("fss-prettyFilename"));
            fileObject.setContentType((String)userMetadata.get("fss-contentType"));
            fileObject.setUploadedBy((String)userMetadata.get("fss-uploadedBy"));
            String uploadedAt = (String)userMetadata.get("fss-uploadedAt");
            fileObject.setUploadedAt(uploadedAt != null ? new Date(Long.parseLong(uploadedAt)) : null);
            String size = (String)userMetadata.get("fss-size");
            fileObject.setSize(size != null ? Long.parseLong(size) : -1L);
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
        }
        try {
            HashMap attributes = new HashMap();
            userMetadata.keySet().stream().filter(key -> key.startsWith("fss-attrs-")).forEach(key -> {
                String attributeName = key.substring("fss-attrs-".length());
                attributes.put(attributeName, userMetadata.get(key));
            });
            fileObject.setAttributes(attributes);
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
        }
    }

    private String resolveBucket(StoreFileRequest request) {
        String category = (String)request.getAttributes().get("category");
        String bucket = this.s3Properties.getBuckets().get(category);
        if (StringUtils.isEmpty((Object)bucket)) {
            bucket = this.s3Properties.getDefaultBucket();
        }
        return bucket;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.s3Properties);
        BasicAWSCredentials credentials = new BasicAWSCredentials(this.s3Properties.getAccessKey(), this.s3Properties.getSecretKey());
        AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.s3Properties.getEndpoint(), this.s3Properties.getRegion()));
        if ("path".equalsIgnoreCase(this.s3Properties.getBucketStyle())) {
            builder.withPathStyleAccessEnabled(Boolean.valueOf(true));
        }
        if (this.s3Properties.getClientConfiguration() != null) {
            builder.withClientConfiguration(this.s3Properties.getClientConfiguration());
        }
        this.s3Client = (AmazonS3)builder.build();
    }
}

